/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.plugins.dbinfo.jdbc;

import pl.mpak.orbada.plugins.dbinfo.DbObjectContainer;
import pl.mpak.orbada.plugins.dbinfo.DbObjectIdentified;
import pl.mpak.orbada.plugins.dbinfo.jdbc.JdbcDbSchemaInfo;
import pl.mpak.orbada.plugins.dbinfo.jdbc.JdbcDbTableIndexInfo;
import pl.mpak.orbada.plugins.dbinfo.jdbc.JdbcDbTableInfo;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.variant.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcDbTableIndexListInfo
extends DbObjectContainer<JdbcDbTableIndexInfo> {
    public JdbcDbTableIndexListInfo(JdbcDbTableInfo owner) {
        super("INDEXES", owner);
    }

    public JdbcDbSchemaInfo getSchema() {
        DbObjectIdentified o = this.getOwner(JdbcDbSchemaInfo.class);
        if (o != null) {
            return (JdbcDbSchemaInfo)o;
        }
        return null;
    }

    public JdbcDbTableInfo getTable() {
        DbObjectIdentified o = this.getOwner(JdbcDbTableInfo.class);
        if (o != null) {
            return (JdbcDbTableInfo)o;
        }
        return null;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"Pozycja", "Nazwa kolumny", "Unikalny", "AscDesc"};
    }

    @Override
    public String[] getMemberNames() {
        return new String[0];
    }

    @Override
    public Variant[] getMemberValues() {
        return new Variant[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() throws Exception {
        if (this.isRefreshing()) {
            return;
        }
        this.setRefreshing(true);
        try {
            this.clear();
            Query query = this.getDatabase().createQuery();
            try {
                JdbcDbSchemaInfo schema = this.getSchema();
                query.setResultSet(this.getDatabase().getMetaData().getIndexInfo(this.getTable().getCatalog(), schema == null ? null : schema.getName(), this.getTable().getObjectName(), false, false));
                while (!query.eof()) {
                    JdbcDbTableIndexInfo index = new JdbcDbTableIndexInfo(query.fieldByName("index_name").getString(), this);
                    index.setColumnName(query.fieldByName("column_name").getString());
                    index.setPosition(query.fieldByName("ordinal_position").getInteger());
                    if ("A".equals(query.fieldByName("asc_or_desc").getString())) {
                        index.setAscDesc("ASC");
                    } else if ("D".equals(query.fieldByName("asc_or_desc").getString())) {
                        index.setAscDesc("DESC");
                    } else {
                        index.setAscDesc("");
                    }
                    index.setUnique(!query.fieldByName("non_unique").getBoolean());
                    this.put(index.getName() + "." + index.getColumnName(), index);
                    query.next();
                }
            }
            finally {
                query.close();
            }
        }
        finally {
            this.setRefreshed(true);
        }
    }
}

