/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.plugins.dbinfo.jdbc;

import pl.mpak.orbada.plugins.dbinfo.DbObjectContainer;
import pl.mpak.orbada.plugins.dbinfo.DbObjectIdentified;
import pl.mpak.orbada.plugins.dbinfo.jdbc.JdbcDbSchemaInfo;
import pl.mpak.orbada.plugins.dbinfo.jdbc.JdbcDbTableInfo;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.variant.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcDbTableListInfo
extends DbObjectContainer<JdbcDbTableInfo> {
    public JdbcDbTableListInfo(DbObjectIdentified owner) {
        super("TABLES", owner);
    }

    public JdbcDbSchemaInfo getSchema() {
        DbObjectIdentified o = this.getOwner(JdbcDbSchemaInfo.class);
        if (o != null) {
            return (JdbcDbSchemaInfo)o;
        }
        return null;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"Katalog", "Komentarz"};
    }

    @Override
    public String[] getMemberNames() {
        return new String[0];
    }

    @Override
    public Variant[] getMemberValues() {
        return new Variant[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() throws Exception {
        if (this.isRefreshing()) {
            return;
        }
        this.setRefreshing(true);
        try {
            this.clear();
            Query query = this.getDatabase().createQuery();
            try {
                JdbcDbSchemaInfo schema = this.getSchema();
                query.setResultSet(this.getDatabase().getMetaData().getTables(schema == null ? null : schema.getCatalog(), schema == null ? null : schema.getName(), null, new String[]{"TABLE", "SYSTEM TABLE"}));
                while (!query.eof()) {
                    JdbcDbTableInfo table = new JdbcDbTableInfo(query.fieldByName("table_name").getString(), this);
                    table.setObjectName(query.fieldByName("table_name").getString());
                    table.setCatalog(query.fieldByName("table_cat").getString());
                    table.setRemarks(query.fieldByName("remarks").getString());
                    this.put(table);
                    query.next();
                }
            }
            finally {
                query.close();
            }
        }
        finally {
            this.setRefreshed(true);
        }
    }
}

