/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.plugins.dbinfo.jdbc;

import pl.mpak.orbada.plugins.dbinfo.DbObjectContainer;
import pl.mpak.orbada.plugins.dbinfo.DbObjectIdentified;
import pl.mpak.orbada.plugins.dbinfo.DefaultDbObjectContainer;
import pl.mpak.orbada.plugins.dbinfo.DefaultDbObjectIdentified;
import pl.mpak.orbada.plugins.dbinfo.jdbc.JdbcDbPrivilegeInfo;
import pl.mpak.orbada.plugins.dbinfo.jdbc.JdbcDbSchemaInfo;
import pl.mpak.orbada.plugins.dbinfo.jdbc.JdbcDbViewColumnInfo;
import pl.mpak.orbada.plugins.dbinfo.jdbc.JdbcDbViewListInfo;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.variant.Variant;

public class JdbcDbViewInfo
extends DbObjectContainer {
    private String objectName;
    private String catalog;

    public JdbcDbViewInfo(String name, JdbcDbViewListInfo owner) {
        super(name, owner);
        this.put(new DefaultDbObjectContainer("COLUMNS", this){

            public String[] getColumnNames() {
                return new String[]{"Pozycja", "Typ", "Rozmiar", "Prec.", "Null?", "Komentarz"};
            }
        });
        this.put(new DefaultDbObjectContainer<JdbcDbPrivilegeInfo>("PRIVILEGES", (DbObjectIdentified)this){

            @Override
            public String[] getColumnNames() {
                return new String[]{"Nada\u0142", "Dla", "Admin"};
            }
        });
        this.put(new DefaultDbObjectIdentified("CONTENT", this));
    }

    public JdbcDbSchemaInfo getSchema() {
        DbObjectIdentified o = this.getOwner(JdbcDbSchemaInfo.class);
        if (o != null) {
            return (JdbcDbSchemaInfo)o;
        }
        return null;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String[] getColumnNames() {
        return new String[0];
    }

    public String[] getMemberNames() {
        return new String[]{"Katalog", "Komentarz"};
    }

    public Variant[] getMemberValues() {
        return new Variant[]{new Variant(this.getCatalog()), new Variant(this.getRemarks())};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws Exception {
        if (this.isRefreshing()) {
            return;
        }
        this.setRefreshing(true);
        try {
            DbObjectContainer columns = (DbObjectContainer)this.get("COLUMNS");
            columns.setRefreshing(true);
            columns.clear();
            Query query = this.getDatabase().createQuery();
            try {
                JdbcDbSchemaInfo schema = this.getSchema();
                query.setResultSet(this.getDatabase().getMetaData().getColumns(this.getCatalog(), schema == null ? null : schema.getName(), this.getObjectName(), "%"));
                while (!query.eof()) {
                    JdbcDbViewColumnInfo column = new JdbcDbViewColumnInfo(query.fieldByName("column_name").getString(), this);
                    column.setDefaultValue(query.fieldByName("column_def").getString());
                    column.setPosition(query.fieldByName("ordinal_position").getInteger());
                    column.setDataType(query.fieldByName("type_name").getString());
                    column.setDataSize(query.fieldByName("column_size").getInteger());
                    column.setDigits(query.fieldByName("decimal_digits").getInteger());
                    column.setNullable(query.fieldByName("nullable").getInteger() == 1);
                    column.setRemarks(query.fieldByName("remarks").getString());
                    columns.put(column);
                    query.next();
                }
            }
            finally {
                query.close();
                columns.setRefreshed(true);
            }
            DbObjectContainer privileges = (DbObjectContainer)this.get("PRIVILEGES");
            privileges.setRefreshing(true);
            privileges.clear();
            try {
                JdbcDbSchemaInfo schema = this.getSchema();
                query.setResultSet(this.getDatabase().getMetaData().getTablePrivileges(this.getCatalog(), schema == null ? null : schema.getName(), this.getObjectName()));
                while (!query.eof()) {
                    JdbcDbPrivilegeInfo privilege = new JdbcDbPrivilegeInfo(query.fieldByName("PRIVILEGE").getString(), this);
                    privilege.setGrantor(query.fieldByName("GRANTOR").getString());
                    privilege.setGrantee(query.fieldByName("GRANTEE").getString());
                    privilege.setGrantable(query.fieldByName("IS_GRANTABLE").getString());
                    privileges.put(privilege);
                    query.next();
                }
            }
            finally {
                query.close();
                privileges.setRefreshing(true);
            }
        }
        finally {
            this.setRefreshed(true);
        }
    }
}

