/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.plugins.dbinfo.jdbc;

import pl.mpak.orbada.plugins.dbinfo.DbObjectContainer;
import pl.mpak.orbada.plugins.dbinfo.DbObjectIdentified;
import pl.mpak.orbada.plugins.dbinfo.jdbc.JdbcDbSchemaInfo;
import pl.mpak.orbada.plugins.dbinfo.jdbc.JdbcDbViewInfo;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.StringUtil;
import pl.mpak.util.variant.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcDbViewListInfo
extends DbObjectContainer<JdbcDbViewInfo> {
    public JdbcDbViewListInfo(DbObjectIdentified owner) {
        super("VIEWS", owner);
    }

    public JdbcDbSchemaInfo getSchema() {
        DbObjectIdentified o = this.getOwner(JdbcDbSchemaInfo.class);
        if (o != null) {
            return (JdbcDbSchemaInfo)o;
        }
        return null;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"Katalog", "Komentarz"};
    }

    @Override
    public String[] getMemberNames() {
        return new String[0];
    }

    @Override
    public Variant[] getMemberValues() {
        return new Variant[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() throws Exception {
        if (this.isRefreshing()) {
            return;
        }
        this.setRefreshing(true);
        try {
            this.clear();
            Query query = this.getDatabase().createQuery();
            try {
                JdbcDbSchemaInfo schema = this.getSchema();
                query.setResultSet(this.getDatabase().getMetaData().getTables(schema == null ? null : schema.getCatalog(), schema == null ? null : schema.getName(), null, new String[]{"VIEW"}));
                while (!query.eof()) {
                    String name = query.fieldByName("table_name").getString();
                    if (!StringUtil.isEmpty((String)query.fieldByName("table_cat").getString())) {
                        name = query.fieldByName("table_cat").getString() + "." + name;
                    }
                    JdbcDbViewInfo view = new JdbcDbViewInfo(name, this);
                    view.setObjectName(query.fieldByName("table_name").getString());
                    view.setCatalog(query.fieldByName("table_cat").getString());
                    view.setRemarks(query.fieldByName("remarks").getString());
                    if (StringUtil.isEmpty((String)view.getCatalog())) {
                        this.put(view);
                    } else {
                        this.put(view.getCatalog() + "." + view.getName(), view);
                    }
                    query.next();
                }
            }
            finally {
                query.close();
            }
        }
        finally {
            this.setRefreshed(true);
        }
    }
}

