/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.plugins.queue;

import java.util.ArrayList;
import java.util.concurrent.SynchronousQueue;
import pl.mpak.orbada.plugins.IProcessMessagable;
import pl.mpak.orbada.plugins.queue.PluginMessage;
import pl.mpak.plugins.Plugin;
import pl.mpak.plugins.PluginManager;
import pl.mpak.util.ExceptionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginQueue
extends Thread {
    private SynchronousQueue<PluginMessage> queue = new SynchronousQueue(true);
    private PluginManager pluginManager;
    private ArrayList<IProcessMessagable> extendedMessagerList;

    public PluginQueue(PluginManager pluginManager) {
        super("plugin-queue");
        this.pluginManager = pluginManager;
        this.setPriority(1);
        this.setDaemon(true);
    }

    public boolean post(PluginMessage message) throws InterruptedException {
        this.queue.put(message);
        return true;
    }

    public void setExtendedMessagerList(ArrayList<IProcessMessagable> messagerList) {
        this.extendedMessagerList = messagerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                ArrayList<IProcessMessagable> arrayList;
                PluginMessage message;
                while (true) {
                    if ((message = this.queue.take()) == null) {
                        continue;
                    }
                    arrayList = this.pluginManager.getPluginList();
                    synchronized (arrayList) {
                        for (Plugin plugin : this.pluginManager.getPluginList()) {
                            if (message.getDestinationId() != null && !message.getDestinationId().equals(plugin.getUniqueID()) || !(plugin.getPlugin() instanceof IProcessMessagable)) continue;
                            try {
                                ((IProcessMessagable)plugin.getPlugin()).processMessage(message);
                            }
                            catch (Throwable ex) {
                                ExceptionUtil.processException((Throwable)ex);
                            }
                            if (message.getDestinationId() == null && !message.isServed()) continue;
                            break;
                        }
                    }
                    if (this.extendedMessagerList != null && !message.isServed()) break;
                }
                arrayList = this.extendedMessagerList;
                synchronized (arrayList) {
                    for (IProcessMessagable pm : this.extendedMessagerList) {
                        pm.processMessage(message);
                        if (!message.isServed()) continue;
                        break;
                    }
                    continue;
                }
            }
            catch (InterruptedException ex) {
                ExceptionUtil.processException((Throwable)ex);
                continue;
            }
            break;
        }
    }
}

