/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.imports.csv.engine;

import com.csvreader.CsvReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Scanner;
import javax.swing.event.EventListenerList;
import pl.mpak.orbada.imports.csv.engine.CsvImportAbortedException;
import pl.mpak.orbada.imports.csv.engine.CsvImportColumn;
import pl.mpak.orbada.imports.csv.engine.CsvImportConfiguration;
import pl.mpak.orbada.imports.csv.engine.CsvImportEvent;
import pl.mpak.orbada.imports.csv.engine.CsvImportListener;
import pl.mpak.orbada.imports.csv.engine.CsvImportSqlException;
import pl.mpak.usedb.br.DefaultBufferedRecord;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringUtil;

public class CsvImport {
    private CsvImportConfiguration configuration;
    private final EventListenerList importListenerList = new EventListenerList();
    private volatile long recordCount;

    public CsvImport() {
    }

    public CsvImport(CsvImportConfiguration configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImportListener(CsvImportListener listener) {
        EventListenerList eventListenerList = this.importListenerList;
        synchronized (eventListenerList) {
            this.importListenerList.add(CsvImportListener.class, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImportListener(CsvImportListener listener) {
        EventListenerList eventListenerList = this.importListenerList;
        synchronized (eventListenerList) {
            this.importListenerList.remove(CsvImportListener.class, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fireQueryListener(Event event, String[] strings, long recNo, boolean analyzing) {
        EventListenerList eventListenerList = this.importListenerList;
        synchronized (eventListenerList) {
            int result = 0;
            CsvImportEvent eo = new CsvImportEvent(this, analyzing, strings, recNo);
            CsvImportListener[] listeners = (CsvImportListener[])this.importListenerList.getListeners(CsvImportListener.class);
            block16: for (int i = 0; i < listeners.length; ++i) {
                switch (event) {
                    case BEFORE_IMPORT: {
                        listeners[i].beforeImport(eo);
                        switch (eo.getAction()) {
                            case 2: {
                                result = 2;
                            }
                        }
                        continue block16;
                    }
                    case AFTER_IMPORT: {
                        listeners[i].afterImport(eo);
                        continue block16;
                    }
                    case BEFORE_RECORD: {
                        listeners[i].beforeImportRecord(eo);
                        switch (eo.getAction()) {
                            case 2: {
                                result = 2;
                                break;
                            }
                            case 1: {
                                result = 1;
                            }
                        }
                        continue block16;
                    }
                    case AFTER_RECORD: {
                        listeners[i].afterImportRecord(eo);
                    }
                }
            }
            return result;
        }
    }

    public CsvImportConfiguration getConfiguration() {
        return this.configuration;
    }

    private int detectType(String value, CsvImportColumn column) {
        int dataType = 11;
        if (StringUtil.isEmpty((String)value)) {
            dataType = 1;
        } else if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("on")) {
            dataType = 8;
        } else if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no") || value.equalsIgnoreCase("off")) {
            dataType = 8;
        } else {
            try {
                BigDecimal bd = new BigDecimal(value);
                if (bd.scale() > column.getDataScale()) {
                    column.setDataScale(bd.scale());
                }
                dataType = 14;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            try {
                DateFormat.getDateTimeInstance().parse(value);
                dataType = 20;
            }
            catch (ParseException e) {
                try {
                    DateFormat.getDateInstance().parse(value);
                    dataType = 7;
                }
                catch (ParseException ex) {
                    // empty catch block
                }
            }
        }
        if (dataType != 1 && column.getColumnType() != 11) {
            if (column.getColumnType() == 0) {
                column.setColumnType(dataType);
            } else {
                switch (column.getColumnType()) {
                    case 8: {
                        if (dataType == 8) break;
                        column.setColumnType(11);
                        break;
                    }
                    case 14: {
                        if (dataType == 14 || dataType == 3) break;
                        column.setDataScale(0);
                        column.setColumnType(11);
                        break;
                    }
                    case 7: {
                        if (dataType == 20) {
                            column.setColumnType(20);
                            break;
                        }
                        if (dataType == 7) break;
                        column.setColumnType(11);
                        break;
                    }
                    case 20: {
                        if (dataType == 7 || dataType == 20) break;
                        column.setColumnType(11);
                    }
                }
            }
        }
        return column.getColumnType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readFirstLines(int rowCount) throws FileNotFoundException {
        if (this.configuration == null) {
            throw new IllegalArgumentException("configuration is null");
        }
        StringBuilder sb = new StringBuilder();
        String NL = System.getProperty("line.separator");
        Scanner scanner = new Scanner((InputStream)new FileInputStream(this.configuration.getFileName()), this.configuration.getEncoding());
        try {
            while (scanner.hasNextLine()) {
                if (--rowCount < 0) {
                    break;
                }
                sb.append(scanner.nextLine()).append(NL);
            }
        }
        finally {
            scanner.close();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String[]> readFirstRows(int rowCount) throws IOException {
        if (this.configuration == null) {
            throw new IllegalArgumentException("configuration is null");
        }
        ArrayList<String[]> rows = new ArrayList<String[]>();
        CsvReader csv = this.configuration.createReader();
        try {
            if (this.configuration.isHeaderPresent()) {
                csv.readHeaders();
            }
            rows.add(csv.getHeaders());
            while (csv.readRecord()) {
                if (--rowCount < 0) {
                    break;
                }
                rows.add(csv.getValues());
            }
        }
        finally {
            csv.close();
        }
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CsvImportColumn[] analyze() throws IOException, CsvImportAbortedException {
        if (this.configuration == null) {
            throw new IllegalArgumentException("configuration is null");
        }
        CsvImportColumn[] columns = null;
        CsvReader csv = this.configuration.createReader();
        this.recordCount = 0L;
        try {
            int eventResult;
            int i;
            if (this.configuration.isHeaderPresent()) {
                csv.readHeaders();
                String[] headers = csv.getHeaders();
                if (headers != null && headers.length == 1) {
                    Character ch = null;
                    if (StringUtil.charCount((String)headers[0], (char)';') >= 1) {
                        ch = Character.valueOf(';');
                    } else if (StringUtil.charCount((String)headers[0], (char)',') >= 1) {
                        ch = Character.valueOf(',');
                    } else if (StringUtil.charCount((String)headers[0], (char)'|') >= 1) {
                        ch = Character.valueOf('|');
                    } else if (StringUtil.charCount((String)headers[0], (char)'\t') >= 1) {
                        ch = Character.valueOf('\t');
                    } else if (StringUtil.charCount((String)headers[0], (char)' ') >= 1) {
                        ch = Character.valueOf(' ');
                    }
                    if (ch != null) {
                        csv.close();
                        this.configuration.setDelimiter(ch.charValue());
                        csv = this.configuration.createReader();
                        csv.readHeaders();
                        headers = csv.getHeaders();
                        if (headers != null && headers.length <= 1) {
                            this.configuration.setDelimiter(csv.getDelimiter());
                        }
                    }
                }
                columns = new CsvImportColumn[headers.length];
                for (i = 0; i < headers.length; ++i) {
                    columns[i] = new CsvImportColumn(headers[i]);
                    columns[i].setNotNull(true);
                    columns[i].setIndex(i);
                }
                eventResult = this.fireQueryListener(Event.BEFORE_IMPORT, csv.getHeaders(), -1L, true);
                if (eventResult == 2) {
                    throw new CsvImportAbortedException();
                }
                if (eventResult == 3) {
                    CsvImportColumn[] csvImportColumnArray = columns;
                    return csvImportColumnArray;
                }
            }
            while (csv.readRecord()) {
                ++this.recordCount;
                String[] values = csv.getValues();
                if (columns == null) {
                    columns = new CsvImportColumn[values.length];
                    for (i = 0; i < values.length; ++i) {
                        columns[i] = new CsvImportColumn(i);
                        columns[i].setNotNull(true);
                    }
                }
                if ((eventResult = this.fireQueryListener(Event.BEFORE_RECORD, csv.getValues(), csv.getCurrentRecord() + 1L, true)) == 2) {
                    throw new CsvImportAbortedException();
                }
                if (eventResult != 0) continue;
                for (int i2 = 0; i2 < values.length; ++i2) {
                    CsvImportColumn column = columns[i2];
                    if (values[i2].length() > column.getColumnLength()) {
                        column.setColumnLength(values[i2].length());
                    }
                    if (StringUtil.isEmpty((String)values[i2])) {
                        column.setNotNull(false);
                    }
                    this.detectType(values[i2], column);
                }
                this.fireQueryListener(Event.AFTER_RECORD, csv.getValues(), csv.getCurrentRecord() + 1L, true);
            }
            this.fireQueryListener(Event.AFTER_IMPORT, null, -1L, true);
        }
        finally {
            csv.close();
        }
        return columns;
    }

    public void truncateTable(Database database) throws Exception {
        database.executeCommand("TRUNCATE TABLE " + this.configuration.getImportTableName());
    }

    private String primaryKeyScript() {
        String[] pk = this.configuration.getImportTablePrimaryKey();
        if (pk != null && pk.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (String field : pk) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(field);
            }
            return "primary key (" + sb.toString() + ")";
        }
        return "";
    }

    public String createTableScript(Database database) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (CsvImportColumn c : this.configuration.getColumnList()) {
            if (sb.length() > 0) {
                sb.append(",\n");
            }
            String columnName = c.getColumnName();
            sb.append("  ").append(columnName);
            sb.append(" ").append(SQLUtil.typeToString((int)SQLUtil.variantToSqlType((int)c.getColumnType())));
            if (c.getColumnType() == 11) {
                sb.append("(").append(this.configuration.getPrecisionRound() == 1 ? c.getColumnLength() : (c.getColumnLength() / this.configuration.getPrecisionRound() + 1) * this.configuration.getPrecisionRound()).append(")");
            } else if (c.getColumnType() == 14) {
                sb.append("(").append(this.configuration.getPrecisionRound() == 1 ? c.getColumnLength() : (c.getColumnLength() / this.configuration.getPrecisionRound() + 1) * this.configuration.getPrecisionRound()).append(",").append(c.getDataScale()).append(")");
            }
            if ((!this.configuration.isAddNullCheck() || !c.isNotNull()) && StringUtil.anyOfString((String)columnName, (String[])this.configuration.getImportTablePrimaryKey(), (boolean)true) < 0) continue;
            sb.append(" NOT NULL");
        }
        return "CREATE TABLE " + this.configuration.getImportTableName() + " (\n" + sb.toString() + (this.configuration.isAddPrimaryKey() ? ",\n  " + this.primaryKeyScript() : "") + "\n)";
    }

    public void createTable(Database database) throws Exception {
        database.executeCommand(this.createTableScript(database));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Database database) throws CsvImportSqlException, IOException, CsvImportAbortedException {
        block37: {
            block36: {
                if (this.configuration == null) {
                    throw new IllegalArgumentException("configuration is null");
                }
                if (this.configuration.getColumnList() == null || this.configuration.getColumnList().isEmpty()) {
                    throw new IllegalArgumentException("column list is empty");
                }
                if (this.configuration.getImportMode() == CsvImportConfiguration.ImportMode.CREATE_TABLE_INSERT) {
                    try {
                        if (!StringUtil.isEmpty((String)this.configuration.getTableCreationCommand())) {
                            database.executeCommand(this.configuration.getTableCreationCommand());
                        } else {
                            this.createTable(database);
                        }
                    }
                    catch (Exception ex) {
                        if (this.configuration.isIgnoreErrors()) break block36;
                        throw new CsvImportSqlException(ex);
                    }
                }
            }
            if (this.configuration.getImportMode() == CsvImportConfiguration.ImportMode.TRUNCATE_AND_INSERT) {
                try {
                    this.truncateTable(database);
                }
                catch (Exception ex) {
                    if (this.configuration.isIgnoreErrors()) break block37;
                    throw new CsvImportSqlException(ex);
                }
            }
        }
        DefaultBufferedRecord qbr = new DefaultBufferedRecord(database, this.configuration.getImportTableName(), null){

            private String afterSqlText(String sqlText) {
                for (CsvImportColumn col : CsvImport.this.configuration.getColumnList()) {
                    if (StringUtil.isEmpty((String)col.getSqlColumnAction())) continue;
                    String value = col.getSqlColumnAction();
                    if (col.getSqlColumnAction().indexOf("%s") >= 0) {
                        value = String.format(value, ":" + col.getColumnName());
                    }
                    sqlText = StringUtil.replaceString((String)sqlText, (String)(":" + col.getColumnName()), (String)value);
                }
                return sqlText;
            }

            protected String afterInsertSqlText(String sqlText) {
                return this.afterSqlText(sqlText);
            }

            protected String afterUpdateSqlText(String sqlText) {
                return this.afterSqlText(sqlText);
            }
        };
        qbr.setPrimaryKeys(this.configuration.getImportTablePrimaryKey());
        for (CsvImportColumn col : this.configuration.getColumnList()) {
            qbr.add(col.getColumnName(), StringUtil.isEmpty((String)col.getSqlColumnAction()) ? col.getColumnType() : 11, true);
        }
        this.recordCount = 0L;
        CsvReader csv = this.configuration.createReader();
        try {
            if (this.configuration.isHeaderPresent()) {
                csv.readHeaders();
                int eventResult = this.fireQueryListener(Event.BEFORE_IMPORT, csv.getHeaders(), -1L, false);
                if (eventResult == 2) {
                    throw new CsvImportAbortedException();
                }
                if (eventResult == 3) {
                    return;
                }
            }
            while (csv.readRecord()) {
                block38: {
                    ++this.recordCount;
                    int eventResult = this.fireQueryListener(Event.BEFORE_RECORD, csv.getValues(), csv.getCurrentRecord() + 1L, false);
                    if (eventResult == 2) {
                        throw new CsvImportAbortedException();
                    }
                    if (eventResult != 0) continue;
                    qbr.clearValues();
                    for (CsvImportColumn col : this.configuration.getColumnList()) {
                        String value = this.configuration.isHeaderPresent() ? csv.get(col.getCsvColumnName()) : csv.get(col.getIndex());
                        qbr.fieldByName(col.getColumnName()).setString(value);
                    }
                    try {
                        if (this.configuration.getImportMode() == CsvImportConfiguration.ImportMode.TRUNCATE_AND_INSERT || this.configuration.getImportMode() == CsvImportConfiguration.ImportMode.INSERT_ALL || this.configuration.getImportMode() == CsvImportConfiguration.ImportMode.CREATE_TABLE_INSERT) {
                            qbr.applyInsert();
                        } else if (this.configuration.getImportMode() == CsvImportConfiguration.ImportMode.UPDATE_OR_INSERT) {
                            if (qbr.recordExists()) {
                                qbr.applyUpdate();
                            } else {
                                qbr.applyInsert();
                            }
                        } else if (this.configuration.getImportMode() == CsvImportConfiguration.ImportMode.INSERT_NEW) {
                            if (!qbr.recordExists()) {
                                qbr.applyInsert();
                            }
                        } else if (this.configuration.getImportMode() == CsvImportConfiguration.ImportMode.DELETE_ONLY) {
                            if (qbr.recordExists()) {
                                qbr.applyDelete();
                            }
                        } else if (this.configuration.getImportMode() == CsvImportConfiguration.ImportMode.UPDATE_ONLY && qbr.recordExists()) {
                            qbr.applyUpdate();
                        }
                    }
                    catch (Exception ex) {
                        if (this.configuration.isIgnoreErrors()) break block38;
                        throw new CsvImportSqlException(ex);
                    }
                }
                this.fireQueryListener(Event.AFTER_RECORD, csv.getValues(), csv.getCurrentRecord() + 1L, false);
            }
            this.fireQueryListener(Event.AFTER_IMPORT, null, -1L, false);
        }
        finally {
            csv.close();
        }
    }

    public long getRecordCount() {
        return this.recordCount;
    }

    public static enum Event {
        BEFORE_IMPORT,
        AFTER_IMPORT,
        BEFORE_RECORD,
        AFTER_RECORD;

    }
}

