/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.imports.csv.engine;

import com.csvreader.CsvReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import pl.mpak.orbada.imports.csv.engine.CsvImportColumn;
import pl.mpak.util.StringUtil;

public class CsvImportConfiguration {
    private String fileName;
    private char delimiter = (char)44;
    private int escapeMode = 2;
    private char recordDelimiter = (char)10;
    private boolean skipEmptyRecords = true;
    private char textQualifier = (char)34;
    private boolean trimWhitespace = true;
    private boolean useTextQualifier = true;
    private boolean ignoreErrors = false;
    private String encoding = "UTF-8";
    private boolean headerPresent = true;
    private int precisionRound = 10;
    private ImportMode importMode = ImportMode.INSERT_ALL;
    private boolean tableAutomatic = true;
    private boolean addNullCheck = true;
    private boolean addPrimaryKey = false;
    private String tableName;
    private String[] tablePrimaryKey;
    private String tableCreationCommand;
    private ArrayList<CsvImportColumn> columnList = new ArrayList();

    public CsvReader configureReader(CsvReader csv) {
        csv.setDelimiter(this.delimiter);
        csv.setEscapeMode(this.escapeMode);
        csv.setRecordDelimiter(this.recordDelimiter);
        csv.setSkipEmptyRecords(this.skipEmptyRecords);
        csv.setTextQualifier(this.textQualifier);
        csv.setTrimWhitespace(this.trimWhitespace);
        csv.setUseTextQualifier(this.useTextQualifier);
        return csv;
    }

    public CsvReader createReader() throws FileNotFoundException {
        return this.configureReader(new CsvReader(this.fileName, this.delimiter, Charset.forName(this.encoding)));
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    public void setDelimiter(String delimiter) {
        if (!StringUtil.isEmpty((String)delimiter)) {
            this.delimiter = delimiter.charAt(0);
        }
    }

    public int getEscapeMode() {
        return this.escapeMode;
    }

    public void setEscapeMode(int escapeMode) {
        this.escapeMode = escapeMode;
    }

    public char getRecordDelimiter() {
        return this.recordDelimiter;
    }

    public void setRecordDelimiter(char recordDelimiter) {
        this.recordDelimiter = recordDelimiter;
    }

    public void setRecordDelimiter(String recordDelimiter) {
        if (!StringUtil.isEmpty((String)recordDelimiter)) {
            this.recordDelimiter = recordDelimiter.charAt(0);
        }
    }

    public boolean isSkipEmptyRecords() {
        return this.skipEmptyRecords;
    }

    public void setSkipEmptyRecords(boolean skipEmptyRecords) {
        this.skipEmptyRecords = skipEmptyRecords;
    }

    public char getTextQualifier() {
        return this.textQualifier;
    }

    public void setTextQualifier(char textQualifier) {
        this.textQualifier = textQualifier;
    }

    public void setTextQualifier(String textQualifier) {
        if (!StringUtil.isEmpty((String)textQualifier)) {
            this.textQualifier = textQualifier.charAt(0);
        }
    }

    public boolean isTrimWhitespace() {
        return this.trimWhitespace;
    }

    public void setTrimWhitespace(boolean trimWhitespace) {
        this.trimWhitespace = trimWhitespace;
    }

    public boolean isUseTextQualifier() {
        return this.useTextQualifier;
    }

    public void setUseTextQualifier(boolean useTextQualifier) {
        this.useTextQualifier = useTextQualifier;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public CsvImportColumn add(String csvColumnName, String tableColumnName, String sqlColumnAction, int tableColumnType) {
        CsvImportColumn c = new CsvImportColumn(csvColumnName, tableColumnName, sqlColumnAction, tableColumnType);
        return this.add(c);
    }

    public CsvImportColumn add(String csvColumnName, String tableColumnName, int tableColumnType) {
        return this.add(csvColumnName, tableColumnName, null, tableColumnType);
    }

    public CsvImportColumn add(CsvImportColumn column) {
        column.setIndex(this.columnList.size());
        this.columnList.add(column);
        return column;
    }

    public void add(CsvImportColumn[] columns) {
        if (columns == null) {
            throw new IllegalArgumentException("column is null");
        }
        this.columnList.addAll(Arrays.asList(columns));
    }

    public ArrayList<CsvImportColumn> getColumnList() {
        return this.columnList;
    }

    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }

    public void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    public String[] getTablePrimaryKey() {
        return this.tablePrimaryKey;
    }

    public void setTablePrimaryKey(String[] tablePrimaryKey) {
        this.tablePrimaryKey = tablePrimaryKey;
    }

    public boolean isHeaderPresent() {
        return this.headerPresent;
    }

    public void setHeaderPresent(boolean headerPresent) {
        this.headerPresent = headerPresent;
    }

    public int getPrecisionRound() {
        return this.precisionRound;
    }

    public void setPrecisionRound(int precisionRound) {
        this.precisionRound = precisionRound;
    }

    public ImportMode getImportMode() {
        return this.importMode;
    }

    public void setImportMode(ImportMode importMode) {
        this.importMode = importMode;
    }

    public boolean isAddNullCheck() {
        return this.addNullCheck;
    }

    public void setAddNullCheck(boolean addNullCheck) {
        this.addNullCheck = addNullCheck;
    }

    public boolean isAddPrimaryKey() {
        return this.addPrimaryKey;
    }

    public void setAddPrimaryKey(boolean addPrimaryKey) {
        this.addPrimaryKey = addPrimaryKey;
    }

    public String getTableCreationCommand() {
        return this.tableCreationCommand;
    }

    public void setTableCreationCommand(String tableCreationCommand) {
        this.tableCreationCommand = tableCreationCommand;
    }

    public boolean isTableAutomatic() {
        return this.tableAutomatic;
    }

    public void setTableAutomatic(boolean tableAutomatic) {
        this.tableAutomatic = tableAutomatic;
    }

    public String getImportTableName() {
        if (this.tableAutomatic) {
            return new File(this.fileName).getName().replaceFirst("[.][^.]+$", "");
        }
        return this.tableName;
    }

    public String[] getImportTablePrimaryKey() {
        if (this.tableAutomatic && this.columnList != null && !this.columnList.isEmpty()) {
            return new String[]{this.columnList.get(0).getColumnName()};
        }
        return this.tablePrimaryKey;
    }

    public static enum ImportMode {
        CREATE_TABLE_INSERT,
        TRUNCATE_AND_INSERT,
        INSERT_NEW,
        UPDATE_OR_INSERT,
        DELETE_ONLY,
        UPDATE_ONLY,
        INSERT_ALL;

    }
}

