/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.imports.csv.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import pl.mpak.orbada.gui.comps.OrbadaSyntaxTextArea;
import pl.mpak.orbada.imports.csv.OrbadaImportCsvPlugin;
import pl.mpak.orbada.imports.csv.engine.CsvImport;
import pl.mpak.orbada.imports.csv.engine.CsvImportColumn;
import pl.mpak.orbada.imports.csv.engine.CsvImportConfiguration;
import pl.mpak.orbada.imports.csv.engine.CsvImportEvent;
import pl.mpak.orbada.imports.csv.engine.CsvImportListener;
import pl.mpak.orbada.imports.csv.gui.TableComboBoxModel;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ComboBox;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.FileUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.files.FileExtensionFilter;

public class ImportFromCsvDialog
extends JDialog {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaImportCsvPlugin.class);
    private int modalResult = 0;
    private CsvImportConfiguration config;
    private CsvImportColumn[] columns;
    private Database database;
    private JButton buttonAnalyze;
    private JButton buttonCancel;
    private JButton buttonOk;
    private JButton buttonReset;
    private JCheckBox checkAddNullCheck;
    private JCheckBox checkAddPrimaryKey;
    private JCheckBox checkFullAuto;
    private JCheckBox checkHeaderPresent;
    private JCheckBox checkIgnoreErrors;
    private JCheckBox checkTrimWhitespace;
    private JCheckBox checkUseTextQualifier;
    private Action cmAnalyze;
    private Action cmCancel;
    private Action cmOk;
    private Action cmReset;
    private Action cmSelectFile;
    private ComboBox comboCharset;
    private ComboBox comboDelimiter;
    private ComboBox comboEndOfLineChar;
    private ComboBox comboEscapeMode;
    private ComboBox comboTable;
    private ComboBox comboTextQualifier;
    private ButtonGroup groupImportMode;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JTabbedPane jTabbedPane1;
    private JPanel panelMain;
    private JPanel panelMode;
    private JPanel panelTable;
    private JRadioButton radioCREATE_TABLE_INSERT;
    private JRadioButton radioDELETE_ONLY;
    private JRadioButton radioINSERT_ALL;
    private JRadioButton radioINSERT_NEW;
    private JRadioButton radioTRUNCATE_AND_INSERT;
    private JRadioButton radioUPDATE_ONLY;
    private JRadioButton radioUPDATE_OR_INSERT;
    private TextField textFileName;
    private JSpinner textPrecisionRound;
    private TextField textPrimaryKeyColumns;
    private OrbadaSyntaxTextArea textTableCreatCode;
    private ToolButton toolButton1;

    public ImportFromCsvDialog(CsvImportConfiguration config, Database database) {
        super(SwingUtil.getRootFrame(), true);
        this.database = database;
        this.config = config;
        this.initComponents();
        this.init();
    }

    public static boolean showDialog(CsvImportConfiguration config, Database database) {
        final ImportFromCsvDialog dialog = new ImportFromCsvDialog(config, database);
        if (dialog.selectFile()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    dialog.analyze();
                }
            });
            dialog.setVisible(true);
            return dialog.modalResult == 1;
        }
        return false;
    }

    private void init() {
        this.comboTable.setModel((ComboBoxModel)new TableComboBoxModel(this.database));
        SwingUtil.centerWithinScreen((Window)this);
        for (Charset charset : Charset.availableCharsets().values()) {
            this.comboCharset.addItem((Object)charset.displayName());
        }
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        this.getRootPane().setDefaultButton(this.buttonOk);
        SwingUtil.setButtonSizesTheSame((AbstractButton[])new JButton[]{this.buttonOk, this.buttonCancel, this.buttonAnalyze, this.buttonReset});
        this.configToDialog(this.config);
    }

    private void configToDialog(CsvImportConfiguration config) {
        try {
            this.comboCharset.setText(config.getEncoding());
            this.textFileName.setText(config.getFileName());
            if (config.getDelimiter() == '\t') {
                this.comboDelimiter.setText("TAB");
            } else if (config.getDelimiter() == ' ') {
                this.comboDelimiter.setText("SPACE");
            } else {
                this.comboDelimiter.setText("" + config.getDelimiter());
            }
            this.comboTextQualifier.setText("" + config.getTextQualifier());
            this.checkUseTextQualifier.setSelected(config.isUseTextQualifier());
            if (config.getEscapeMode() == 2) {
                this.comboEscapeMode.setText("BACKSLASH");
            } else if (config.getEscapeMode() == 1) {
                this.comboEscapeMode.setText("DOUBLED");
            }
            if (config.getRecordDelimiter() == '\n') {
                this.comboEndOfLineChar.setText("\\n");
            } else if (config.getRecordDelimiter() == '\r') {
                this.comboEndOfLineChar.setText("\\r");
            } else if (config.getRecordDelimiter() == '\f') {
                this.comboEndOfLineChar.setText("\\f");
            }
            this.checkTrimWhitespace.setSelected(config.isTrimWhitespace());
            this.textPrecisionRound.setValue(config.getPrecisionRound());
            this.checkHeaderPresent.setSelected(config.isHeaderPresent());
            this.checkIgnoreErrors.setSelected(config.isIgnoreErrors());
            switch (config.getImportMode()) {
                case CREATE_TABLE_INSERT: {
                    this.radioCREATE_TABLE_INSERT.setSelected(true);
                    break;
                }
                case DELETE_ONLY: {
                    this.radioDELETE_ONLY.setSelected(true);
                    break;
                }
                case INSERT_ALL: {
                    this.radioINSERT_ALL.setSelected(true);
                    break;
                }
                case INSERT_NEW: {
                    this.radioINSERT_NEW.setSelected(true);
                    break;
                }
                case TRUNCATE_AND_INSERT: {
                    this.radioTRUNCATE_AND_INSERT.setSelected(true);
                    break;
                }
                case UPDATE_ONLY: {
                    this.radioUPDATE_ONLY.setSelected(true);
                    break;
                }
                case UPDATE_OR_INSERT: {
                    this.radioUPDATE_OR_INSERT.setSelected(true);
                }
            }
            this.checkFullAuto.setSelected(config.isTableAutomatic());
            this.comboTable.setText(config.getTableName());
            this.textPrimaryKeyColumns.setText(Arrays.asList(config.getTablePrimaryKey()).toString().replaceAll("[\\[|\\]]", ""));
            this.checkAddPrimaryKey.setSelected(config.isAddPrimaryKey());
            this.checkAddNullCheck.setSelected(config.isAddNullCheck());
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void dialogToConfig(CsvImportConfiguration config) {
        config.setEncoding(this.comboCharset.getText());
        config.setFileName(this.textFileName.getText());
        if ("TAB".equals(this.comboDelimiter.getText())) {
            config.setDelimiter('\t');
        } else if ("SPACE".equals(this.comboDelimiter.getText())) {
            config.setDelimiter(' ');
        } else {
            config.setDelimiter(this.comboDelimiter.getText());
        }
        config.setTextQualifier(this.comboTextQualifier.getText());
        config.setUseTextQualifier(this.checkUseTextQualifier.isSelected());
        if ("BACKSLASH".equals(this.comboEscapeMode.getText())) {
            config.setEscapeMode(2);
        } else if ("DOUBLED".equals(this.comboEscapeMode.getText())) {
            config.setEscapeMode(1);
        }
        if ("\\n".equals(this.comboEndOfLineChar.getText())) {
            config.setRecordDelimiter('\n');
        } else if ("\\r".equals(this.comboEndOfLineChar.getText())) {
            config.setRecordDelimiter('\r');
        } else if ("\\f".equals(this.comboEndOfLineChar.getText())) {
            config.setRecordDelimiter('\f');
        }
        config.setTrimWhitespace(this.checkTrimWhitespace.isSelected());
        config.setPrecisionRound((Integer)this.textPrecisionRound.getValue());
        config.setHeaderPresent(this.checkHeaderPresent.isSelected());
        config.setIgnoreErrors(this.checkIgnoreErrors.isSelected());
        if (this.radioCREATE_TABLE_INSERT.isSelected()) {
            config.setImportMode(CsvImportConfiguration.ImportMode.CREATE_TABLE_INSERT);
        } else if (this.radioDELETE_ONLY.isSelected()) {
            config.setImportMode(CsvImportConfiguration.ImportMode.DELETE_ONLY);
        } else if (this.radioINSERT_ALL.isSelected()) {
            config.setImportMode(CsvImportConfiguration.ImportMode.INSERT_ALL);
        } else if (this.radioINSERT_NEW.isSelected()) {
            config.setImportMode(CsvImportConfiguration.ImportMode.INSERT_NEW);
        } else if (this.radioTRUNCATE_AND_INSERT.isSelected()) {
            config.setImportMode(CsvImportConfiguration.ImportMode.TRUNCATE_AND_INSERT);
        } else if (this.radioUPDATE_ONLY.isSelected()) {
            config.setImportMode(CsvImportConfiguration.ImportMode.UPDATE_ONLY);
        } else if (this.radioUPDATE_OR_INSERT.isSelected()) {
            config.setImportMode(CsvImportConfiguration.ImportMode.UPDATE_OR_INSERT);
        }
        config.setTableAutomatic(this.checkFullAuto.isSelected());
        config.setTableName(this.comboTable.getText());
        config.setTablePrimaryKey(this.textPrimaryKeyColumns.getText().split(","));
        config.setAddPrimaryKey(this.checkAddPrimaryKey.isSelected());
        config.setAddNullCheck(this.checkAddNullCheck.isSelected());
        if (!config.isTableAutomatic()) {
            config.setTableCreationCommand(this.textTableCreatCode.getText());
        }
        config.getColumnList().clear();
        if (this.columns != null) {
            config.add(this.columns);
        }
    }

    private boolean selectFile() {
        File lastFile = null;
        try {
            if (!StringUtil.isEmpty((String)this.textFileName.getText())) {
                lastFile = new File(this.textFileName.getText());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        lastFile = FileUtil.selectFileToOpen((Component)this, null, null, (File)lastFile, (FileExtensionFilter[])new FileExtensionFilter[]{new FileExtensionFilter(this.stringManager.getString("ImportFromCsvDialog-csv-files"), new String[]{".csv"})});
        if (lastFile != null) {
            this.textFileName.setText(lastFile.getAbsoluteFile().toString());
            return true;
        }
        return false;
    }

    private void updateTableCreation() {
        if (this.columns != null) {
            try {
                CsvImportConfiguration cnf = new CsvImportConfiguration();
                this.dialogToConfig(cnf);
                CsvImport csv = new CsvImport(cnf);
                this.textTableCreatCode.setText(csv.createTableScript(this.database));
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
        }
    }

    private void analyze() {
        try {
            CsvImportConfiguration cnf = new CsvImportConfiguration();
            this.dialogToConfig(cnf);
            CsvImport csv = new CsvImport(cnf);
            csv.addImportListener(new CsvImportListener(){

                @Override
                public void beforeImport(CsvImportEvent event) {
                }

                @Override
                public void afterImport(CsvImportEvent event) {
                }

                @Override
                public void beforeImportRecord(CsvImportEvent event) {
                    if (event.isAnalyzing() && event.getRecNo() > 1000L) {
                        event.setAction(3);
                    }
                }

                @Override
                public void afterImportRecord(CsvImportEvent event) {
                }
            });
            this.columns = csv.analyze();
            this.configToDialog(cnf);
            this.updateTableCreation();
        }
        catch (Exception ex) {
            MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
    }

    private void initComponents() {
        this.cmOk = new Action();
        this.cmCancel = new Action();
        this.cmSelectFile = new Action();
        this.groupImportMode = new ButtonGroup();
        this.cmAnalyze = new Action();
        this.cmReset = new Action();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.panelMode = new JPanel();
        this.jLabel8 = new JLabel();
        this.textFileName = new TextField();
        this.toolButton1 = new ToolButton();
        this.checkIgnoreErrors = new JCheckBox();
        this.radioCREATE_TABLE_INSERT = new JRadioButton();
        this.radioTRUNCATE_AND_INSERT = new JRadioButton();
        this.radioINSERT_NEW = new JRadioButton();
        this.radioUPDATE_OR_INSERT = new JRadioButton();
        this.radioDELETE_ONLY = new JRadioButton();
        this.radioUPDATE_ONLY = new JRadioButton();
        this.radioINSERT_ALL = new JRadioButton();
        this.panelMain = new JPanel();
        this.jLabel7 = new JLabel();
        this.comboCharset = new ComboBox();
        this.comboDelimiter = new ComboBox();
        this.jLabel18 = new JLabel();
        this.comboTextQualifier = new ComboBox();
        this.jLabel19 = new JLabel();
        this.checkUseTextQualifier = new JCheckBox();
        this.jLabel20 = new JLabel();
        this.comboEscapeMode = new ComboBox();
        this.jLabel21 = new JLabel();
        this.comboEndOfLineChar = new ComboBox();
        this.checkTrimWhitespace = new JCheckBox();
        this.jLabel22 = new JLabel();
        this.textPrecisionRound = new JSpinner();
        this.checkHeaderPresent = new JCheckBox();
        this.panelTable = new JPanel();
        this.checkFullAuto = new JCheckBox();
        this.jLabel9 = new JLabel();
        this.comboTable = new ComboBox();
        this.jLabel10 = new JLabel();
        this.textPrimaryKeyColumns = new TextField();
        this.checkAddPrimaryKey = new JCheckBox();
        this.checkAddNullCheck = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.textTableCreatCode = new OrbadaSyntaxTextArea();
        this.buttonReset = new JButton();
        this.buttonAnalyze = new JButton();
        this.cmOk.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmOk.setText(this.stringManager.getString("cmOk-text"));
        this.cmOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportFromCsvDialog.this.cmOkActionPerformed(evt);
            }
        });
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(this.stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportFromCsvDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.cmSelectFile.setSmallIcon((Icon)new ImageIcon(this.getClass().getResource("/pl/mpak/res/icons/open16.gif")));
        this.cmSelectFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportFromCsvDialog.this.cmSelectFileActionPerformed(evt);
            }
        });
        this.cmAnalyze.setText(this.stringManager.getString("cmAnalyze-text"));
        this.cmAnalyze.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportFromCsvDialog.this.cmAnalyzeActionPerformed(evt);
            }
        });
        this.cmReset.setText(this.stringManager.getString("cmReset-text"));
        this.cmReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportFromCsvDialog.this.cmResetActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.buttonOk.setAction((javax.swing.Action)this.cmOk);
        this.buttonOk.setPreferredSize(new Dimension(75, 23));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setPreferredSize(new Dimension(75, 23));
        this.jTabbedPane1.setFocusable(false);
        this.jLabel8.setText(this.stringManager.getString("ImportFromCsvDialog-file-name-dd"));
        this.toolButton1.setAction((javax.swing.Action)this.cmSelectFile);
        this.checkIgnoreErrors.setText(this.stringManager.getString("ImportFromCsvDialog-checkIgnoreErrors-text"));
        this.groupImportMode.add(this.radioCREATE_TABLE_INSERT);
        this.radioCREATE_TABLE_INSERT.setText(this.stringManager.getString("CREATE_TABLE_INSERT"));
        this.groupImportMode.add(this.radioTRUNCATE_AND_INSERT);
        this.radioTRUNCATE_AND_INSERT.setText(this.stringManager.getString("TRUNCATE_AND_INSERT"));
        this.groupImportMode.add(this.radioINSERT_NEW);
        this.radioINSERT_NEW.setText(this.stringManager.getString("INSERT_NEW"));
        this.groupImportMode.add(this.radioUPDATE_OR_INSERT);
        this.radioUPDATE_OR_INSERT.setText(this.stringManager.getString("UPDATE_OR_INSERT"));
        this.groupImportMode.add(this.radioDELETE_ONLY);
        this.radioDELETE_ONLY.setText(this.stringManager.getString("DELETE_ONLY"));
        this.groupImportMode.add(this.radioUPDATE_ONLY);
        this.radioUPDATE_ONLY.setText(this.stringManager.getString("UPDATE_ONLY"));
        this.groupImportMode.add(this.radioINSERT_ALL);
        this.radioINSERT_ALL.setText(this.stringManager.getString("INSERT_ALL"));
        GroupLayout panelModeLayout = new GroupLayout(this.panelMode);
        this.panelMode.setLayout(panelModeLayout);
        panelModeLayout.setHorizontalGroup(panelModeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelModeLayout.createSequentialGroup().addContainerGap().addGroup(panelModeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.radioUPDATE_ONLY, -2, -1, -2).addComponent(this.radioDELETE_ONLY, -2, -1, -2).addComponent(this.radioUPDATE_OR_INSERT, -2, -1, -2).addComponent(this.radioINSERT_NEW, -2, -1, -2).addComponent(this.radioINSERT_ALL, -2, -1, -2).addComponent(this.radioTRUNCATE_AND_INSERT, -2, -1, -2).addComponent(this.radioCREATE_TABLE_INSERT, -2, -1, -2).addComponent(this.checkIgnoreErrors).addGroup(GroupLayout.Alignment.TRAILING, panelModeLayout.createSequentialGroup().addGroup(panelModeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8).addComponent((Component)this.textFileName, -1, 404, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.toolButton1, -2, -1, -2))).addContainerGap()));
        panelModeLayout.setVerticalGroup(panelModeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelModeLayout.createSequentialGroup().addContainerGap().addGroup(panelModeLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.toolButton1, -2, -1, -2).addGroup(panelModeLayout.createSequentialGroup().addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textFileName, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkIgnoreErrors).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioCREATE_TABLE_INSERT, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioTRUNCATE_AND_INSERT, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioINSERT_ALL, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioINSERT_NEW, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioUPDATE_OR_INSERT, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioDELETE_ONLY, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioUPDATE_ONLY, -2, -1, -2).addContainerGap(42, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(this.stringManager.getString("ImportFromCsvDialog-import-mode-tab"), this.panelMode);
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText(this.stringManager.getString("ImportFromCsvDialog-charset-dd"));
        this.comboDelimiter.setEditable(true);
        this.comboDelimiter.setModel(new DefaultComboBoxModel<String>(new String[]{",", ";", "|", "TAB", "SPACE"}));
        this.jLabel18.setHorizontalAlignment(4);
        this.jLabel18.setText(this.stringManager.getString("ImportFromCsvDialog-separator-dd"));
        this.comboTextQualifier.setModel(new DefaultComboBoxModel<String>(new String[]{"\"", "'", "`"}));
        this.jLabel19.setHorizontalAlignment(4);
        this.jLabel19.setText(this.stringManager.getString("ImportFromCsvDialog-text-qualifier-dd"));
        this.checkUseTextQualifier.setText(this.stringManager.getString("ImportFromCsvDialog-checkUseTextQualifier-text"));
        this.jLabel20.setHorizontalAlignment(4);
        this.jLabel20.setText(this.stringManager.getString("ImportFromCsvDialog-escape-mode-dd"));
        this.comboEscapeMode.setModel(new DefaultComboBoxModel<String>(new String[]{"BACKSLASH", "DOUBLED"}));
        this.jLabel21.setHorizontalAlignment(4);
        this.jLabel21.setText(this.stringManager.getString("ImportFromCsvDialog-end-of-line-char-dd"));
        this.comboEndOfLineChar.setModel(new DefaultComboBoxModel<String>(new String[]{"\\n", "\\r", "\\f"}));
        this.checkTrimWhitespace.setText(this.stringManager.getString("ImportFromCsvDialog-checkTrimWhitespace-text"));
        this.jLabel22.setHorizontalAlignment(4);
        this.jLabel22.setText(this.stringManager.getString("ImportFromCsvDialog-precision-round-dd"));
        this.textPrecisionRound.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.checkHeaderPresent.setText(this.stringManager.getString("ImportFromCsvDialog-checkHeaderPresent-text"));
        GroupLayout panelMainLayout = new GroupLayout(this.panelMain);
        this.panelMain.setLayout(panelMainLayout);
        panelMainLayout.setHorizontalGroup(panelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelMainLayout.createSequentialGroup().addContainerGap().addGroup(panelMainLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel22, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel21, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel20, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel19, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel18, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel7, GroupLayout.Alignment.LEADING, -2, 110, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkHeaderPresent).addComponent(this.checkTrimWhitespace).addComponent(this.checkUseTextQualifier).addComponent((Component)this.comboCharset, GroupLayout.Alignment.TRAILING, -1, 322, Short.MAX_VALUE).addComponent(this.textPrecisionRound, -2, 55, -2).addGroup(panelMainLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent((Component)this.comboEndOfLineChar, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent((Component)this.comboEscapeMode, GroupLayout.Alignment.LEADING, -1, 127, Short.MAX_VALUE).addComponent((Component)this.comboTextQualifier, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent((Component)this.comboDelimiter, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        panelMainLayout.setVerticalGroup(panelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelMainLayout.createSequentialGroup().addContainerGap().addGroup(panelMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent((Component)this.comboCharset, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel18).addComponent((Component)this.comboDelimiter, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel19).addComponent((Component)this.comboTextQualifier, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkUseTextQualifier).addGap(4, 4, 4).addGroup(panelMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.comboEscapeMode, -2, -1, -2).addComponent(this.jLabel20)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel21).addComponent((Component)this.comboEndOfLineChar, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkTrimWhitespace).addGap(4, 4, 4).addGroup(panelMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel22).addComponent(this.textPrecisionRound, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkHeaderPresent).addContainerGap(145, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(this.stringManager.getString("ImportFromCsvDialog-main-tab"), this.panelMain);
        this.checkFullAuto.setText(this.stringManager.getString("ImportFromCsvDialog-checkFullAuto-text"));
        this.checkFullAuto.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ImportFromCsvDialog.this.checkFullAutoItemStateChanged(evt);
            }
        });
        this.jLabel9.setHorizontalAlignment(4);
        this.jLabel9.setText(this.stringManager.getString("ImportFromCsvDialog-table-name-dd"));
        this.comboTable.setEditable(true);
        this.comboTable.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ImportFromCsvDialog.this.comboTableFocusLost(evt);
            }
        });
        this.jLabel10.setHorizontalAlignment(4);
        this.jLabel10.setText(this.stringManager.getString("ImportFromCsvDialog-primary-key-columns-dd"));
        this.textPrimaryKeyColumns.setToolTipText(this.stringManager.getString("ImportFromCsvDialog-primary-key-columns-tooltip-dd"));
        this.textPrimaryKeyColumns.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ImportFromCsvDialog.this.textPrimaryKeyColumnsFocusLost(evt);
            }
        });
        this.checkAddPrimaryKey.setText(this.stringManager.getString("ImportFromCsvDialog-checkAddPrimaryKey-text"));
        this.checkAddPrimaryKey.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ImportFromCsvDialog.this.checkAddPrimaryKeyItemStateChanged(evt);
            }
        });
        this.checkAddNullCheck.setText(this.stringManager.getString("ImportFromCsvDialog-checkAddNullCheck-text"));
        this.checkAddNullCheck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ImportFromCsvDialog.this.checkAddNullCheckItemStateChanged(evt);
            }
        });
        this.jLabel1.setText(this.stringManager.getString("ImportFromCsvDialog-table-create-source-dd"));
        GroupLayout panelTableLayout = new GroupLayout(this.panelTable);
        this.panelTable.setLayout(panelTableLayout);
        panelTableLayout.setHorizontalGroup(panelTableLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panelTableLayout.createSequentialGroup().addContainerGap().addGroup(panelTableLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.textTableCreatCode, GroupLayout.Alignment.LEADING, -1, 436, Short.MAX_VALUE).addComponent(this.checkFullAuto, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, panelTableLayout.createSequentialGroup().addGroup(panelTableLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel10, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel9, GroupLayout.Alignment.LEADING, -1, 121, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelTableLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.textPrimaryKeyColumns, -1, 311, Short.MAX_VALUE).addComponent((Component)this.comboTable, -1, 311, Short.MAX_VALUE).addComponent(this.checkAddPrimaryKey).addComponent(this.checkAddNullCheck))).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING)).addContainerGap()));
        panelTableLayout.setVerticalGroup(panelTableLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelTableLayout.createSequentialGroup().addContainerGap().addComponent(this.checkFullAuto).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelTableLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent((Component)this.comboTable, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelTableLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent((Component)this.textPrimaryKeyColumns, -2, -1, -2)).addGroup(panelTableLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelTableLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkAddPrimaryKey).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkAddNullCheck)).addGroup(panelTableLayout.createSequentialGroup().addGap(49, 49, 49).addComponent(this.jLabel1))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textTableCreatCode, -1, 219, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab(this.stringManager.getString("ImportFromCsvDialog-table-tab"), this.panelTable);
        this.buttonReset.setAction((javax.swing.Action)this.cmReset);
        this.buttonReset.setPreferredSize(new Dimension(75, 23));
        this.buttonAnalyze.setAction((javax.swing.Action)this.cmAnalyze);
        this.buttonAnalyze.setPreferredSize(new Dimension(75, 23));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTabbedPane1, GroupLayout.Alignment.LEADING, -1, 461, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.buttonReset, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 149, Short.MAX_VALUE).addComponent(this.buttonAnalyze, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane1, -1, 405, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonOk, -2, -1, -2).addComponent(this.buttonReset, -2, -1, -2).addComponent(this.buttonAnalyze, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void cmOkActionPerformed(ActionEvent evt) {
        File file = new File(this.textFileName.getText());
        if (file.exists()) {
            this.modalResult = 1;
            this.dialogToConfig(this.config);
            this.dispose();
        } else {
            MessageBox.show((Component)this, (String)this.stringManager.getString("file"), (String)this.stringManager.getString("file-not-exists-msg"), (int)1, (int)0);
        }
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.dispose();
    }

    private void cmSelectFileActionPerformed(ActionEvent evt) {
        if (this.selectFile()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ImportFromCsvDialog.this.analyze();
                }
            });
        }
    }

    private void cmResetActionPerformed(ActionEvent evt) {
        this.configToDialog(this.config);
    }

    private void cmAnalyzeActionPerformed(ActionEvent evt) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImportFromCsvDialog.this.analyze();
            }
        });
    }

    private void comboTableFocusLost(FocusEvent evt) {
        this.updateTableCreation();
    }

    private void textPrimaryKeyColumnsFocusLost(FocusEvent evt) {
        this.updateTableCreation();
    }

    private void checkAddPrimaryKeyItemStateChanged(ItemEvent evt) {
        this.updateTableCreation();
    }

    private void checkAddNullCheckItemStateChanged(ItemEvent evt) {
        this.updateTableCreation();
    }

    private void checkFullAutoItemStateChanged(ItemEvent evt) {
        this.updateTableCreation();
    }
}

