/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.imports.csv.services;

import java.awt.Component;
import java.util.Arrays;
import pl.mpak.orbada.imports.csv.OrbadaImportCsvPlugin;
import pl.mpak.orbada.imports.csv.engine.CsvImport;
import pl.mpak.orbada.imports.csv.engine.CsvImportAbortedException;
import pl.mpak.orbada.imports.csv.engine.CsvImportConfiguration;
import pl.mpak.orbada.imports.csv.engine.CsvImportEvent;
import pl.mpak.orbada.imports.csv.engine.CsvImportListener;
import pl.mpak.orbada.imports.csv.gui.ImportFromCsvDialog;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.providers.ImportToolActionProvider;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.task.Task;

public class ImportFromCsv
extends ImportToolActionProvider {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaImportCsvPlugin.class);
    private CsvImportConfiguration config = new CsvImportConfiguration();

    public ImportFromCsv() {
        this.setText(stringManager.getString("ImportFromCsv-text"));
        this.setActionCommandKey("ImportFromCsv");
    }

    public final String getDescription() {
        return stringManager.getString("ImportFromCsv-description");
    }

    private ISettings getSettings() {
        return this.application.getSettings("import-from-csv-file");
    }

    private void storeSettings() {
        ISettings settings = this.getSettings();
        settings.setValue("encoding", this.config.getEncoding());
        settings.setValue("file-name", this.config.getFileName());
        settings.setValue("table-name", this.config.getTableName());
        settings.setValue("delimiter", "" + this.config.getDelimiter());
        settings.setValue("escape-mode", Long.valueOf(this.config.getEscapeMode()));
        settings.setValue("record-delimiter", "" + this.config.getRecordDelimiter());
        settings.setValue("text-qualifier", "" + this.config.getTextQualifier());
        settings.setValue("header-present", Boolean.valueOf(this.config.isHeaderPresent()));
        settings.setValue("ignore-errors", Boolean.valueOf(this.config.isIgnoreErrors()));
        settings.setValue("skip-empty-records", Boolean.valueOf(this.config.isSkipEmptyRecords()));
        settings.setValue("trim-whitespace", Boolean.valueOf(this.config.isTrimWhitespace()));
        settings.setValue("use-text-qualifier", Boolean.valueOf(this.config.isUseTextQualifier()));
        settings.setValue("add-null-check", Boolean.valueOf(this.config.isAddNullCheck()));
        settings.setValue("add-primary-key", Boolean.valueOf(this.config.isAddPrimaryKey()));
        settings.setValue("precision-round", Long.valueOf(this.config.getPrecisionRound()));
        if (this.config.getTablePrimaryKey() != null) {
            settings.setValue("table-primary-key", Arrays.asList(this.config.getTablePrimaryKey()).toString().replaceAll("[\\[|\\]]", ""));
        } else {
            settings.setValue("table-primary-key", "");
        }
        settings.setValue("table-automatic", Boolean.valueOf(this.config.isTableAutomatic()));
        settings.store();
    }

    private void loadSettings() {
        ISettings settings = this.getSettings();
        this.config.setEncoding(settings.getValue("encoding", this.config.getEncoding()));
        this.config.setFileName(settings.getValue("file-name", this.config.getFileName()));
        this.config.setTableName(settings.getValue("table-name", this.config.getTableName()));
        this.config.setDelimiter(settings.getValue("delimiter", "" + this.config.getDelimiter()));
        this.config.setEscapeMode(settings.getValue("escape-mode", Long.valueOf(this.config.getEscapeMode())).intValue());
        this.config.setRecordDelimiter(settings.getValue("record-delimiter", "" + this.config.getRecordDelimiter()));
        this.config.setTextQualifier(settings.getValue("text-qualifier", "" + this.config.getTextQualifier()));
        this.config.setHeaderPresent(settings.getValue("header-present", Boolean.valueOf(this.config.isHeaderPresent())));
        this.config.setIgnoreErrors(settings.getValue("ignore-errors", Boolean.valueOf(this.config.isIgnoreErrors())));
        this.config.setSkipEmptyRecords(settings.getValue("skip-empty-records", Boolean.valueOf(this.config.isSkipEmptyRecords())));
        this.config.setTrimWhitespace(settings.getValue("trim-whitespace", Boolean.valueOf(this.config.isTrimWhitespace())));
        this.config.setUseTextQualifier(settings.getValue("use-text-qualifier", Boolean.valueOf(this.config.isUseTextQualifier())));
        this.config.setAddNullCheck(settings.getValue("add-null-check", Boolean.valueOf(this.config.isAddNullCheck())));
        this.config.setAddPrimaryKey(settings.getValue("add-primary-key", Boolean.valueOf(this.config.isAddPrimaryKey())));
        this.config.setPrecisionRound(settings.getValue("precision-round", Long.valueOf(this.config.getPrecisionRound())).intValue());
        this.config.setTablePrimaryKey(settings.getValue("table-primary-key", "").split(","));
        this.config.setTableAutomatic(settings.getValue("table-automatic", Boolean.valueOf(this.config.isTableAutomatic())));
    }

    public String getGroupName() {
        return "Import tools";
    }

    public boolean isButton() {
        return false;
    }

    protected void doImport(final Database database) {
        this.loadSettings();
        if (ImportFromCsvDialog.showDialog(this.config, database)) {
            this.storeSettings();
            String description = "Csv import";
            database.getTaskPool().addTask(new Task("Csv import"){

                public void run() {
                    try {
                        CsvImport csv = new CsvImport(ImportFromCsv.this.config);
                        csv.addImportListener(new CsvImportListener(){
                            long time;

                            @Override
                            public void beforeImport(CsvImportEvent event) {
                                this.time = System.currentTimeMillis();
                            }

                            @Override
                            public void afterImport(CsvImportEvent event) {
                            }

                            @Override
                            public void beforeImportRecord(CsvImportEvent event) {
                                if (this.isCanceled()) {
                                    event.setAction(2);
                                } else if (System.currentTimeMillis() - this.time > 1000L) {
                                    this.setDescription("Csv import " + event.getRecNo());
                                    this.time = System.currentTimeMillis();
                                }
                            }

                            @Override
                            public void afterImportRecord(CsvImportEvent event) {
                            }
                        });
                        csv.process(database);
                    }
                    catch (Exception ex) {
                        if (ex instanceof CsvImportAbortedException) {
                            MessageBox.show((Component)SwingUtil.getRootFrame(), (String)stringManager.getString("import"), (String)stringManager.getString("import-aborted"), (int)1);
                        }
                        ExceptionUtil.processException((Throwable)ex);
                        MessageBox.show((Component)SwingUtil.getRootFrame(), (String)stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
                    }
                }
            });
        }
    }
}

