/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.postgresql;

import java.util.ArrayList;
import java.util.List;
import pl.mpak.orbada.db.InternalDatabase;
import pl.mpak.orbada.plugins.OrbadaPlugin;
import pl.mpak.orbada.plugins.queue.PluginMessage;
import pl.mpak.orbada.postgresql.services.PostgreSQLAggregateListView;
import pl.mpak.orbada.postgresql.services.PostgreSQLDatabaseProvider;
import pl.mpak.orbada.postgresql.services.PostgreSQLDbInfoProvider;
import pl.mpak.orbada.postgresql.services.PostgreSQLFunctionListView;
import pl.mpak.orbada.postgresql.services.PostgreSQLPerspectiveProvider;
import pl.mpak.orbada.postgresql.services.PostgreSQLRoleListView;
import pl.mpak.orbada.postgresql.services.PostgreSQLSchemaListView;
import pl.mpak.orbada.postgresql.services.PostgreSQLSearchObjectView;
import pl.mpak.orbada.postgresql.services.PostgreSQLSearchSourceView;
import pl.mpak.orbada.postgresql.services.PostgreSQLSequenceListView;
import pl.mpak.orbada.postgresql.services.PostgreSQLSessionsView;
import pl.mpak.orbada.postgresql.services.PostgreSQLTableListView;
import pl.mpak.orbada.postgresql.services.PostgreSQLTableSizeView;
import pl.mpak.orbada.postgresql.services.PostgreSQLTablespaceListView;
import pl.mpak.orbada.postgresql.services.PostgreSQLTriggerFunctionListView;
import pl.mpak.orbada.postgresql.services.PostgreSQLTriggerListView;
import pl.mpak.orbada.postgresql.services.PostgreSQLTypesView;
import pl.mpak.orbada.postgresql.services.PostgreSQLViewListView;
import pl.mpak.orbada.postgresql.services.actions.ExplainPlanService;
import pl.mpak.orbada.postgresql.services.actions.FunctionActionsService;
import pl.mpak.orbada.postgresql.services.actions.PostgreSQLCancelQueryAction;
import pl.mpak.orbada.postgresql.services.actions.PostgreSQLSQLWarningsService;
import pl.mpak.orbada.postgresql.services.actions.PostgreSQLTerminateSessionAction;
import pl.mpak.orbada.postgresql.services.actions.TableActionsService;
import pl.mpak.orbada.postgresql.services.actions.TriggerActionsService;
import pl.mpak.orbada.postgresql.services.actions.TypeActionsService;
import pl.mpak.orbada.postgresql.services.actions.ViewActionsService;
import pl.mpak.plugins.spi.IPlugin;
import pl.mpak.plugins.spi.IPluginProvider;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.id.VersionID;
import pl.mpak.util.timer.TimerManager;
import pl.mpak.util.timer.TimerQueue;

public class OrbadaPostgreSQLPlugin
extends OrbadaPlugin {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaPostgreSQLPlugin.class);
    public static final String driverType = "PostgreSQL";
    public static final VersionID version = new VersionID(1, 0, 2, 23);
    public static final String adminGroup = stringManager.getString("OrbadaPostgreSQLPlugin-admin-group");
    private static TimerQueue refreshQueue;
    public static final ArrayList<Class<? extends IPluginProvider>> classList;

    public static TimerQueue getRefreshQueue() {
        if (refreshQueue == null) {
            refreshQueue = TimerManager.getTimer((String)"orbada-postgresql-refresh");
        }
        return refreshQueue;
    }

    public String getInternalName() {
        return "OrbadaPostgreSQLPlugin";
    }

    public String getDescriptiveName() {
        return String.format(stringManager.getString("OrbadaPostgreSQLPlugin-descriptive-name"), this.getVersion());
    }

    public String getDescription() {
        return "";
    }

    public String getCategory() {
        return "IDE,Database,PostgreSQL";
    }

    public String getAuthor() {
        return "Andrzej Ka\u0142u\u017ca";
    }

    public String getCopyrights() {
        return "";
    }

    public String getWebSite() {
        return null;
    }

    public String getUpdateSite() {
        return null;
    }

    public String getVersion() {
        return version.toString();
    }

    public String getLicence() {
        return null;
    }

    public String getUniqueID() {
        return "orbada-postgresql-plugin";
    }

    public void load() {
    }

    public void unload() {
    }

    public void initialize() {
        this.application.registerDriverType(driverType);
        classList.add(PostgreSQLDbInfoProvider.class);
        classList.add(PostgreSQLDatabaseProvider.class);
        classList.add(PostgreSQLPerspectiveProvider.class);
        classList.add(PostgreSQLTableListView.class);
        classList.add(PostgreSQLViewListView.class);
        classList.add(PostgreSQLSearchObjectView.class);
        classList.add(PostgreSQLTableSizeView.class);
        classList.add(PostgreSQLFunctionListView.class);
        classList.add(PostgreSQLTriggerFunctionListView.class);
        classList.add(PostgreSQLSequenceListView.class);
        classList.add(PostgreSQLTablespaceListView.class);
        classList.add(PostgreSQLSchemaListView.class);
        classList.add(PostgreSQLSearchSourceView.class);
        classList.add(PostgreSQLTriggerListView.class);
        classList.add(PostgreSQLSQLWarningsService.class);
        classList.add(PostgreSQLSessionsView.class);
        classList.add(PostgreSQLCancelQueryAction.class);
        classList.add(PostgreSQLTerminateSessionAction.class);
        classList.add(PostgreSQLTypesView.class);
        classList.add(TableActionsService.class);
        classList.add(ViewActionsService.class);
        classList.add(TypeActionsService.class);
        classList.add(FunctionActionsService.class);
        classList.add(TriggerActionsService.class);
        classList.add(PostgreSQLAggregateListView.class);
        classList.add(ExplainPlanService.class);
        classList.add(PostgreSQLRoleListView.class);
        this.initTemplates();
    }

    public boolean requires(List<IPlugin> loadedPlugins) {
        this.addDepend("orbada-universal-plugin");
        for (IPlugin plugin : loadedPlugins) {
            if (!"orbada-universal-plugin".equals(plugin.getUniqueID())) continue;
        }
        return true;
    }

    public Class<IPluginProvider>[] getProviderArray() {
        return classList.toArray(new Class[classList.size()]);
    }

    public void processMessage(PluginMessage message) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTemplates() {
        if (InternalDatabase.get() == null) {
            return;
        }
        Database database = InternalDatabase.get();
        Query query = database.createQuery();
        query.close();
    }

    static {
        classList = new ArrayList();
    }
}

