/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.postgresql.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.Closeable;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import pl.mpak.orbada.gui.comps.table.DataTable;
import pl.mpak.orbada.postgresql.OrbadaPostgreSQLPlugin;
import pl.mpak.orbada.universal.gui.CommandParametersDialog;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.core.Command;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.ParametrizedCommand;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class ExplainPlanPanel
extends JPanel
implements Closeable {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaPostgreSQLPlugin.class);
    private Database database;
    private DataTable data;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTabbedPane jTabbedPane1;
    private QueryTableStatusBar statusBar;

    public ExplainPlanPanel(Database database) {
        this.database = database;
        this.initComponents();
        this.init();
    }

    private void init() {
    }

    public void updatePlan(String sqlText) {
        this.data.getQuery().setDatabase(this.database);
        try {
            this.data.getQuery().setCloseResultAfterOpen(true);
        }
        catch (UseDBException ex) {
            // empty catch block
        }
        try {
            Command command = this.database.createCommand("EXPLAIN\n" + sqlText, false);
            if (command.getParameterList().parameterCount() > 0 && !CommandParametersDialog.showDialog((ParametrizedCommand)command)) {
                return;
            }
            command.execute();
            if (command.getStatement() != null) {
                this.data.getQuery().close();
                this.data.getQuery().setResultSet(command.getStatement().getResultSet());
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ExplainPlanPanel.this.data.getColumnCount() > 0 && ExplainPlanPanel.this.data.getColumnModel().getColumn(0).getWidth() < 100) {
                            ExplainPlanPanel.this.data.getColumnModel().getColumn(0).setPreferredWidth(1000);
                        }
                    }
                });
            }
        }
        catch (Exception ex) {
            MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
    }

    @Override
    public void close() throws IOException {
        this.data.getQuery().close();
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.statusBar = new QueryTableStatusBar();
        this.jScrollPane1 = new JScrollPane();
        this.data = new DataTable();
        this.setLayout(new BorderLayout());
        this.jTabbedPane1.setFocusable(false);
        this.jPanel1.setLayout(new BorderLayout());
        this.statusBar.setTable((QueryTable)this.data);
        this.jPanel1.add((Component)this.statusBar, "South");
        this.jScrollPane1.setViewportView((Component)this.data);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.jTabbedPane1.addTab(this.stringManager.getString("ExplainPlanPanel-tab_plan"), this.jPanel1);
        this.add((Component)this.jTabbedPane1, "Center");
    }
}

