/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.postgresql.gui;

import pl.mpak.orbada.gui.ContentPanel;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.postgresql.OrbadaPostgreSQLPlugin;
import pl.mpak.orbada.postgresql.Sql;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class PostgreSQLContentPanel
extends ContentPanel {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaPostgreSQLPlugin.class);
    private String lastSchemaName;
    private String lastTableName;
    private String tableAccesible;
    private String tableColumnList;

    public PostgreSQLContentPanel(IViewAccesibilities accesibilities) {
        super(accesibilities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSqlText(String filter) {
        if (this.lastSchemaName == null || !this.lastSchemaName.equals(this.currentSchemaName) || this.lastTableName == null || !this.lastTableName.equals(this.currentTableName)) {
            Query qry = this.getDatabase().createQuery();
            try {
                qry.setSqlText(Sql.getTableAccessible());
                qry.paramByName("schema_name").setString(this.currentSchemaName);
                qry.paramByName("table_name").setString(this.currentTableName);
                qry.open();
                if (!qry.eof()) {
                    this.tableAccesible = qry.fieldByName("accessible").getString();
                    if ("COLUMN".equals(this.tableAccesible)) {
                        qry.setSqlText(Sql.getTableAccessibleColumnList());
                        qry.paramByName("schema_name").setString(this.currentSchemaName);
                        qry.paramByName("table_name").setString(this.currentTableName);
                        qry.open();
                        if (!qry.eof()) {
                            this.tableColumnList = qry.fieldByName("columns").getString();
                        }
                    }
                }
                this.lastSchemaName = this.currentSchemaName;
                this.lastTableName = this.currentTableName;
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
            finally {
                qry.close();
            }
        }
        if ("COLUMN".equals(this.tableAccesible)) {
            return "select " + this.tableColumnList + "\n" + "  from " + this.getDatabase().quoteName(this.currentSchemaName, this.currentTableName) + "\n" + ("".equals(filter) ? "" : " WHERE " + filter);
        }
        if ("NO".equals(this.tableAccesible)) {
            return "select '" + stringManager.getString("no-right-to-view", (Object)this.currentTableName) + "' info";
        }
        return null;
    }
}

