/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.postgresql.gui.admin;

import java.awt.Color;
import javax.swing.table.TableCellRenderer;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.postgresql.OrbadaPostgreSQLPlugin;
import pl.mpak.orbada.postgresql.Sql;
import pl.mpak.orbada.postgresql.services.PostgreSQLDbInfoProvider;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.tabbed.UniversalPropTab;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableCellRendererFilter;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.crf.YesNoCellRendererFilter;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class SessionLocksTabPanel
extends UniversalPropTab {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaPostgreSQLPlugin.class);
    private boolean superuser;
    private String version;

    public SessionLocksTabPanel(IViewAccesibilities accesibilities) {
        super(accesibilities);
    }

    protected void init() {
        this.version = PostgreSQLDbInfoProvider.instance.getVersion(this.getDatabase());
        this.superuser = StringUtil.toBoolean((String)this.getDatabase().getUserProperties().getProperty("superuser", "false"));
        super.init();
    }

    public String getTitle() {
        return this.stringManager.getString("SessionLocksTabPanel-title");
    }

    public String getPanelName() {
        return "postgresql-session-locks";
    }

    public String getSchemaColumnName() {
        return null;
    }

    public String getObjectColumnName() {
        return "pid";
    }

    public String getPropColumnName() {
        return "object_name";
    }

    public QueryTableColumn[] getTableColumns() {
        return new QueryTableColumn[]{new QueryTableColumn("schema_name", this.stringManager.getString("schema-name"), 80), new QueryTableColumn("owner_name", this.stringManager.getString("owner-name"), 80), new QueryTableColumn("object_type", this.stringManager.getString("object-type"), 90), new QueryTableColumn("object_name", this.stringManager.getString("object-name"), 170), new QueryTableColumn("transaction", this.stringManager.getString("transaction"), 90), new QueryTableColumn("mode", this.stringManager.getString("lock-mode"), 80), new QueryTableColumn("lockwait", this.stringManager.getString("wait-lock"), 30, (TableCellRenderer)new QueryTableCellRenderer((QueryTableCellRendererFilter)new YesNoCellRendererFilter(Color.RED, SwingUtil.Color.GREEN)))};
    }

    public String getSql(SqlFilter filter) {
        return Sql.getSessionLockList(filter.getSqlText(), this.version);
    }

    public SqlFilterDefComponent[] getFilterDefComponent() {
        return new SqlFilterDefComponent[]{new SqlFilterDefComponent("object_type", this.stringManager.getString("object-type"), (String[])null), new SqlFilterDefComponent("schema_name", this.stringManager.getString("schema-name"), (String[])null), new SqlFilterDefComponent("object_type", this.stringManager.getString("object-type"), (String[])null), new SqlFilterDefComponent("object_name", this.stringManager.getString("object-name"), (String[])null), new SqlFilterDefComponent("mode", this.stringManager.getString("lock-mode"), (String[])null), new SqlFilterDefComponent("lockwait", this.stringManager.getString("wait-lock"))};
    }

    public void afterOpen(Query query) {
        this.requestRefresh = true;
    }
}

