/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.postgresql.gui.admin;

import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.postgresql.OrbadaPostgreSQLPlugin;
import pl.mpak.orbada.postgresql.Sql;
import pl.mpak.orbada.postgresql.gui.admin.SessionTabbedPane;
import pl.mpak.orbada.postgresql.services.PostgreSQLDbInfoProvider;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.tabbed.UniversalViewTabs;
import pl.mpak.sky.gui.swing.comp.RefreshEvent;
import pl.mpak.sky.gui.swing.comp.RefreshListener;
import pl.mpak.sky.gui.swing.comp.RefreshPanel;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class SessionsPanelView
extends UniversalViewTabs {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaPostgreSQLPlugin.class);
    private boolean superuser;
    private String version;
    private RefreshPanel refreshPanel;

    public SessionsPanelView(IViewAccesibilities accesibilities) {
        super(accesibilities);
    }

    protected void init() {
        this.version = PostgreSQLDbInfoProvider.instance.getVersion(this.getDatabase());
        this.superuser = StringUtil.toBoolean((String)this.getDatabase().getUserProperties().getProperty("superuser", "false"));
        this.refreshPanel = new RefreshPanel();
        this.refreshPanel.addRefreshListener(new RefreshListener(){

            public void refresh(RefreshEvent e) {
                SessionsPanelView.this.refresh();
            }
        });
        this.getToolBar().add((Component)this.refreshPanel);
        super.init();
    }

    public Component getTabbedPane() {
        return new SessionTabbedPane(this.accesibilities);
    }

    public String getCurrentSchemaName() {
        return null;
    }

    public String getPanelName() {
        return "postgresql-sessions";
    }

    public String getSchemaColumnName() {
        return null;
    }

    public String getObjectColumnName() {
        return "pid";
    }

    public String getDescriptionColumnName() {
        return null;
    }

    public QueryTableColumn[] getTableColumns() {
        ArrayList<QueryTableColumn> columns = new ArrayList<QueryTableColumn>();
        QueryTableCellRenderer renderer = new QueryTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (!isSelected) {
                    try {
                        if (!SessionsPanelView.this.getQuery().fieldByName("waiting").isNull() && SessionsPanelView.this.getQuery().fieldByName("waiting").getBoolean()) {
                            label.setBackground(new Color(251, 121, 121));
                        } else if (SessionsPanelView.this.getQuery().fieldByName("this").getBoolean()) {
                            label.setBackground(new Color(180, 205, 240));
                        } else if (SessionsPanelView.this.getQuery().fieldByName("state").isNull() && value != null) {
                            label.setForeground(Color.DARK_GRAY);
                        }
                    }
                    catch (Exception ex) {
                        label.setText(label.getText() + " [" + ex.getMessage() + "]");
                    }
                }
                return label;
            }
        };
        columns.add(new QueryTableColumn("pid", this.stringManager.getString("pid"), 50, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("database_name", this.stringManager.getString("database-name"), 80, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("user_name", this.stringManager.getString("user-name"), 80, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("application_name", this.stringManager.getString("application-name"), 200, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("client_host", this.stringManager.getString("client-host"), 150, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("backend_start", this.stringManager.getString("session-time"), 120, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("query_start", this.stringManager.getString("query-time"), 120, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("runned", this.stringManager.getString("runned-sec"), 50, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("blocked_pid", this.stringManager.getString("blocked-pid"), 70, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("state", this.stringManager.getString("state"), 60, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("query", this.stringManager.getString("command"), 350, (TableCellRenderer)renderer));
        return columns.toArray(new QueryTableColumn[columns.size()]);
    }

    public String getSql(SqlFilter filter) {
        return Sql.getSessionList(filter.getSqlText(), this.version);
    }

    public SqlFilterDefComponent[] getFilterDefComponent() {
        return new SqlFilterDefComponent[]{new SqlFilterDefComponent("database_name", this.stringManager.getString("database-name"), (String[])null), new SqlFilterDefComponent("user_name", this.stringManager.getString("user-name"), (String[])null), new SqlFilterDefComponent("client_host", this.stringManager.getString("client-host"), (String[])null), new SqlFilterDefComponent("runned is not null", this.stringManager.getString("runned-sec")), new SqlFilterDefComponent("state", this.stringManager.getString("state"), (String[])null), new SqlFilterDefComponent("query", this.stringManager.getString("command"), (String[])null), new SqlFilterDefComponent("waiting", this.stringManager.getString("waiting"))};
    }

    public String[] getSchemaList() {
        return null;
    }

    public boolean isHorizontal() {
        return false;
    }

    public void close() throws IOException {
        this.refreshPanel.cancel();
        super.close();
    }
}

