/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.postgresql.gui.admin;

import java.awt.Component;
import javax.swing.table.TableCellRenderer;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.postgresql.OrbadaPostgreSQLPlugin;
import pl.mpak.orbada.postgresql.Sql;
import pl.mpak.orbada.postgresql.services.PostgreSQLDbInfoProvider;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.tabbed.UniversalViewTabs;
import pl.mpak.sky.gui.swing.comp.RefreshEvent;
import pl.mpak.sky.gui.swing.comp.RefreshListener;
import pl.mpak.sky.gui.swing.comp.RefreshPanel;
import pl.mpak.sky.gui.swing.comp.SearchEvent;
import pl.mpak.sky.gui.swing.comp.SearchListener;
import pl.mpak.sky.gui.swing.comp.SearchPanel;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.core.ParametrizedCommand;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class TableSizePanelView
extends UniversalViewTabs {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaPostgreSQLPlugin.class);
    private SearchPanel searchPanel;
    private RefreshPanel refreshPanel;

    public TableSizePanelView(IViewAccesibilities accesibilities) {
        super(accesibilities);
    }

    protected void init() {
        this.searchPanel = new SearchPanel();
        this.searchPanel.setTable(this.getTable());
        this.searchPanel.addSearchListener(new SearchListener(){

            public void search(SearchEvent e) {
                TableSizePanelView.this.refresh();
            }
        });
        this.getToolBar().add((Component)this.searchPanel);
        this.refreshPanel = new RefreshPanel();
        this.refreshPanel.addRefreshListener(new RefreshListener(){

            public void refresh(RefreshEvent e) {
                TableSizePanelView.this.refresh();
            }
        });
        this.getToolBar().add((Component)this.refreshPanel);
        super.init();
    }

    public Component getTabbedPane() {
        return null;
    }

    public String getCurrentSchemaName() {
        return PostgreSQLDbInfoProvider.getConnectedSchema(this.getDatabase());
    }

    public String getPanelName() {
        return "postgresql-table-sizes";
    }

    public String getSchemaColumnName() {
        return "schema_name";
    }

    public String getObjectColumnName() {
        return "table_name";
    }

    public String getDescriptionColumnName() {
        return null;
    }

    public QueryTableColumn[] getTableColumns() {
        return new QueryTableColumn[]{new QueryTableColumn("tablespace_name", this.stringManager.getString("tablespace-name"), 150), new QueryTableColumn("owner_name", this.stringManager.getString("owner-name"), 150), new QueryTableColumn("schema_name", this.stringManager.getString("schema-name"), 150), new QueryTableColumn("table_name", this.stringManager.getString("table-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)), new QueryTableColumn("total_size_b", this.stringManager.getString("total-size-b"), 70), new QueryTableColumn("indexes_size_b", this.stringManager.getString("indexes-size-b"), 70), new QueryTableColumn("index_count", this.stringManager.getString("index-count"), 70), new QueryTableColumn("total_size_mb", this.stringManager.getString("total-size-mb"), 70), new QueryTableColumn("prc_size", this.stringManager.getString("prc-size"), 50), new QueryTableColumn("stat_count", this.stringManager.getString("record-count"), 70), new QueryTableColumn("record_length", this.stringManager.getString("record-length"), 50), new QueryTableColumn("last_analyze", this.stringManager.getString("last-analyze"), 130), new QueryTableColumn("last_vacuum", this.stringManager.getString("last-vacuum"), 130), new QueryTableColumn("description", this.stringManager.getString("description"), 250)};
    }

    public String getSql(SqlFilter filter) {
        return Sql.getTableSizeList(filter.getSqlText());
    }

    public SqlFilterDefComponent[] getFilterDefComponent() {
        return new SqlFilterDefComponent[]{new SqlFilterDefComponent("tablespace_name", this.stringManager.getString("tablespace-name"), (String[])null), new SqlFilterDefComponent("owner_name", this.stringManager.getString("owner-name"), (String[])null), new SqlFilterDefComponent("schema_name", this.stringManager.getString("schema-name"), (String[])null), new SqlFilterDefComponent("table_name", this.stringManager.getString("table-name"), (String[])null), new SqlFilterDefComponent("total_size_b", this.stringManager.getString("total-size-b"), (String[])null), new SqlFilterDefComponent("indexes_size_b", this.stringManager.getString("indexes-size-b"), (String[])null), new SqlFilterDefComponent("index_count", this.stringManager.getString("index-count"), (String[])null), new SqlFilterDefComponent("prc_size", this.stringManager.getString("prc-size"), (String[])null), new SqlFilterDefComponent("stat_count", this.stringManager.getString("record-count"), (String[])null), new SqlFilterDefComponent("record_length", this.stringManager.getString("record-length"), (String[])null), new SqlFilterDefComponent("last_analyze", this.stringManager.getString("last-analyze"), (String[])null), new SqlFilterDefComponent("last_vacuum", this.stringManager.getString("last-vacuum"), (String[])null), new SqlFilterDefComponent("description", this.stringManager.getString("description"), (String[])null)};
    }

    public String[] getSchemaList() {
        return PostgreSQLDbInfoProvider.instance.getSchemas(this.getDatabase());
    }

    public void extraSqlParameters(ParametrizedCommand qc) throws UseDBException {
        qc.paramByName("table_name").setString(null);
        qc.paramByName("search_text").setString(this.searchPanel.getText());
    }
}

