/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.postgresql.gui.functions;

import javax.swing.table.TableCellRenderer;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.postgresql.OrbadaPostgreSQLPlugin;
import pl.mpak.orbada.postgresql.Sql;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.tabbed.UniversalPropTab;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class FunctionArgumentListTab
extends UniversalPropTab {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaPostgreSQLPlugin.class);

    public FunctionArgumentListTab(IViewAccesibilities accesibilities) {
        super(accesibilities);
    }

    public String getPanelName() {
        return "postgresql-function-arguments";
    }

    public String getObjectColumnName() {
        return "function_name";
    }

    public String getSchemaColumnName() {
        return "schema_name";
    }

    public String getPropColumnName() {
        return "argument_no";
    }

    public String getSql(SqlFilter filter) {
        return Sql.getFunctionArgumentList(filter.getSqlText());
    }

    public QueryTableColumn[] getTableColumns() {
        return new QueryTableColumn[]{new QueryTableColumn("argument_no", this.stringManager.getString("ordinal"), 30), new QueryTableColumn("argument_name", this.stringManager.getString("argument-name"), 130, (TableCellRenderer)new QueryTableCellRenderer(1)), new QueryTableColumn("argument_type", this.stringManager.getString("data-type"), 130, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.GREEN)), new QueryTableColumn("argument_mode", this.stringManager.getString("argument-mode"), 70), new QueryTableColumn("default_value", this.stringManager.getString("default-value"), 200)};
    }

    public SqlFilterDefComponent[] getFilterDefComponent() {
        return new SqlFilterDefComponent[]{new SqlFilterDefComponent("argument_name", this.stringManager.getString("argument-name"), (String[])null), new SqlFilterDefComponent("argument_type", this.stringManager.getString("data-type"), (String[])null), new SqlFilterDefComponent("argument_mode", this.stringManager.getString("argument-mode"), (String[])null), new SqlFilterDefComponent("default_value", this.stringManager.getString("default-value"), (String[])null)};
    }

    public String getTitle() {
        return this.stringManager.getString("function-arguments");
    }
}

