/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.postgresql.gui.functions;

import java.awt.Color;
import java.awt.Component;
import javax.swing.table.TableCellRenderer;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.postgresql.OrbadaPostgreSQLPlugin;
import pl.mpak.orbada.postgresql.Sql;
import pl.mpak.orbada.postgresql.gui.functions.FunctionTabbedPane;
import pl.mpak.orbada.postgresql.services.PostgreSQLDbInfoProvider;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.tabbed.UniversalViewTabs;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.core.ParametrizedCommand;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableCellRendererFilter;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.crf.ColorListCellRendererFilter;
import pl.mpak.usedb.gui.swing.crf.YesNoCellRendererFilter;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class FunctionListView
extends UniversalViewTabs {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaPostgreSQLPlugin.class);

    public FunctionListView(IViewAccesibilities accesibilities) {
        super(accesibilities);
    }

    public Component getTabbedPane() {
        return new FunctionTabbedPane(this.accesibilities);
    }

    public String getCurrentSchemaName() {
        return PostgreSQLDbInfoProvider.getConnectedSchema(this.getDatabase());
    }

    public String getPanelName() {
        return "postgresql-functions";
    }

    public String getObjectColumnName() {
        return "full_function_name";
    }

    public String getSchemaColumnName() {
        return "schema_name";
    }

    public String getDescriptionColumnName() {
        return "description";
    }

    public String getSql(SqlFilter filter) {
        return Sql.getFunctionList(filter.getSqlText());
    }

    public QueryTableColumn[] getTableColumns() {
        return new QueryTableColumn[]{new QueryTableColumn("schema_name", this.stringManager.getString("schema-name"), 130, (TableCellRenderer)new QueryTableCellRenderer(1)), new QueryTableColumn("function_name", this.stringManager.getString("function-name"), 130, (TableCellRenderer)new QueryTableCellRenderer(1)), new QueryTableColumn("owner_name", this.stringManager.getString("owner-name"), 130), new QueryTableColumn("lang_name", this.stringManager.getString("lang-name"), 130), new QueryTableColumn("accessible", this.stringManager.getString("accessible"), 100, (TableCellRenderer)new QueryTableCellRenderer((QueryTableCellRendererFilter)new ColorListCellRendererFilter(new String[]{"NO"}, new Color[]{Color.RED}))), new QueryTableColumn("isstrict", this.stringManager.getString("is-strict"), 30, (TableCellRenderer)new QueryTableCellRenderer((QueryTableCellRendererFilter)new YesNoCellRendererFilter(SwingUtil.Color.GREEN, null))), new QueryTableColumn("isretset", this.stringManager.getString("is-retset"), 30, (TableCellRenderer)new QueryTableCellRenderer((QueryTableCellRendererFilter)new YesNoCellRendererFilter(SwingUtil.Color.GREEN, null))), new QueryTableColumn("volatile_type", this.stringManager.getString("volatile-type"), 100), new QueryTableColumn("description", this.stringManager.getString("description"), 250), new QueryTableColumn("arguments", this.stringManager.getString("function-arguments"), 200)};
    }

    public SqlFilterDefComponent[] getFilterDefComponent() {
        return new SqlFilterDefComponent[]{new SqlFilterDefComponent("function_name", this.stringManager.getString("function-name"), (String[])null), new SqlFilterDefComponent("arguments", this.stringManager.getString("function-arguments"), (String[])null), new SqlFilterDefComponent("owner_name", this.stringManager.getString("owner-name"), (String[])null), new SqlFilterDefComponent("lang_name", this.stringManager.getString("lang-name"), (String[])null), new SqlFilterDefComponent("description", this.stringManager.getString("description"), (String[])null), new SqlFilterDefComponent("accessible", this.stringManager.getString("accessible"), (String[])null), new SqlFilterDefComponent("volatile_type", this.stringManager.getString("volatile-type"), (String[])null), new SqlFilterDefComponent("isstrict = 'Y'", this.stringManager.getString("is-strict")), new SqlFilterDefComponent("isretset = 'Y'", this.stringManager.getString("is-retset"))};
    }

    public String[] getSchemaList() {
        return PostgreSQLDbInfoProvider.instance.getSchemas(this.getDatabase());
    }

    public void extraSqlParameters(ParametrizedCommand qc) throws UseDBException {
        qc.paramByName("TRIGGER").setString("N");
    }
}

