/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.postgresql.gui.functions;

import javax.swing.table.TableCellRenderer;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.postgresql.OrbadaPostgreSQLPlugin;
import pl.mpak.orbada.postgresql.Sql;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.tabbed.UniversalPropTab;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableCellRendererFilter;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.crf.YesNoCellRendererFilter;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class FunctionPrivilegeListTab
extends UniversalPropTab {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaPostgreSQLPlugin.class);

    public FunctionPrivilegeListTab(IViewAccesibilities accesibilities) {
        super(accesibilities);
    }

    public String getPanelName() {
        return "postgresql-function-privileges";
    }

    public String getSchemaColumnName() {
        return "schema_name";
    }

    public String getObjectColumnName() {
        return "object_name";
    }

    public String getPropColumnName() {
        return "privilege";
    }

    public QueryTableColumn[] getTableColumns() {
        return new QueryTableColumn[]{new QueryTableColumn("grantor", this.stringManager.getString("grantor"), 130), new QueryTableColumn("grantee", this.stringManager.getString("grantee"), 130), new QueryTableColumn("privilege", this.stringManager.getString("privilege"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)), new QueryTableColumn("is_grantable", this.stringManager.getString("is_grantable"), 30, (TableCellRenderer)new QueryTableCellRenderer((QueryTableCellRendererFilter)new YesNoCellRendererFilter(SwingUtil.Color.GREEN, null)))};
    }

    public String getSql(SqlFilter filter) {
        return Sql.getFunctionPrivilegeList(filter.getSqlText());
    }

    public SqlFilterDefComponent[] getFilterDefComponent() {
        return new SqlFilterDefComponent[]{new SqlFilterDefComponent("grantor", this.stringManager.getString("grantor"), (String[])null), new SqlFilterDefComponent("grantee", this.stringManager.getString("grantee"), (String[])null), new SqlFilterDefComponent("privilege", this.stringManager.getString("privilege"), (String[])null), new SqlFilterDefComponent("is_grantable = 'Y'", this.stringManager.getString("is_grantable"))};
    }

    public String getTitle() {
        return this.stringManager.getString("privileges");
    }
}

