/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.postgresql.gui.sequences;

import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.postgresql.OrbadaPostgreSQLPlugin;
import pl.mpak.orbada.postgresql.Sql;
import pl.mpak.orbada.universal.gui.tabbed.UniversalPropDetailsTab;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.core.ParametrizedCommand;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class SequenceDetailsTab
extends UniversalPropDetailsTab {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaPostgreSQLPlugin.class);
    private String sequenceAccesible = "NO";

    public SequenceDetailsTab(IViewAccesibilities accesibilities) {
        super(accesibilities);
    }

    public String getPanelName() {
        return "postgresql-sequence-details";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSql() {
        Query qry = this.getDatabase().createQuery();
        try {
            qry.setSqlText(Sql.getSequenceAccessible());
            qry.paramByName("schema_name").setString(this.currentSchemaName);
            qry.paramByName("sequence_name").setString(this.currentObjectName);
            qry.open();
            if (!qry.eof()) {
                this.sequenceAccesible = qry.fieldByName("accessible").getString();
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            qry.close();
        }
        if ("NO".equalsIgnoreCase(this.sequenceAccesible)) {
            return "select '" + this.stringManager.getString("no-right-to-view", (Object)this.currentObjectName) + "' info";
        }
        return Sql.getSequenceDetails();
    }

    public void extraSqlParameters(ParametrizedCommand qc) throws UseDBException {
        if (!"NO".equalsIgnoreCase(this.sequenceAccesible)) {
            qc.paramByName("schema_name").setString(this.currentSchemaName);
            qc.paramByName("sequence_name").setString(this.currentObjectName);
            qc.paramByName("&schema_name").setString(this.getDatabase().quoteName(this.currentSchemaName));
            qc.paramByName("&sequence_name").setString(this.getDatabase().quoteName(this.currentObjectName));
        }
    }

    public String getTitle() {
        return this.stringManager.getString("details");
    }
}

