/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.postgresql.gui.tables;

import java.awt.Color;
import javax.swing.table.TableCellRenderer;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.postgresql.OrbadaPostgreSQLPlugin;
import pl.mpak.orbada.postgresql.Sql;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.tabbed.UniversalPropTab;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableCellRendererFilter;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.crf.YesNoCellRendererFilter;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class TableConstraintListTab
extends UniversalPropTab {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaPostgreSQLPlugin.class);

    public TableConstraintListTab(IViewAccesibilities accesibilities) {
        super(accesibilities);
    }

    public String getPanelName() {
        return "postgresql-table-constraints";
    }

    public String getObjectColumnName() {
        return "table_name";
    }

    public String getSchemaColumnName() {
        return "schema_name";
    }

    public String getPropColumnName() {
        return "constraint_name";
    }

    public QueryTableColumn[] getTableColumns() {
        return new QueryTableColumn[]{new QueryTableColumn("constraint_name", this.stringManager.getString("constraint-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)), new QueryTableColumn("columns", this.stringManager.getString("constraint-columns"), 130), new QueryTableColumn("constraint_type", this.stringManager.getString("constraint-type"), 130, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.GREEN)), new QueryTableColumn("deferrable", this.stringManager.getString("constraint-deferrable"), 30, (TableCellRenderer)new QueryTableCellRenderer((QueryTableCellRendererFilter)new YesNoCellRendererFilter(null, null))), new QueryTableColumn("deferred", this.stringManager.getString("constraint-deferred"), 30, (TableCellRenderer)new QueryTableCellRenderer((QueryTableCellRendererFilter)new YesNoCellRendererFilter(null, null))), new QueryTableColumn("validated", this.stringManager.getString("constraint-validated"), 30, (TableCellRenderer)new QueryTableCellRenderer((QueryTableCellRendererFilter)new YesNoCellRendererFilter(null, Color.RED))), new QueryTableColumn("fk_table_name", this.stringManager.getString("constraint-fk-table-name"), 130), new QueryTableColumn("fk_columns", this.stringManager.getString("constraint-fk-columns"), 130), new QueryTableColumn("constraint_def", this.stringManager.getString("constraint-def"), 200), new QueryTableColumn("update_rule", this.stringManager.getString("constraint-update-rule"), 130), new QueryTableColumn("delete_rule", this.stringManager.getString("constraint-delete-rule"), 130), new QueryTableColumn("match_type", this.stringManager.getString("constraint-match-type"), 130), new QueryTableColumn("domain_name", this.stringManager.getString("constraint-domain-name"), 130), new QueryTableColumn("description", this.stringManager.getString("description"), 250)};
    }

    public String getSql(SqlFilter filter) {
        return Sql.getConstraintList(filter.getSqlText());
    }

    public SqlFilterDefComponent[] getFilterDefComponent() {
        return new SqlFilterDefComponent[]{new SqlFilterDefComponent("constraint_name", this.stringManager.getString("constraint-name"), (String[])null), new SqlFilterDefComponent("columns", this.stringManager.getString("constraint-columns"), (String[])null), new SqlFilterDefComponent("fk_table_name", this.stringManager.getString("constraint-fk-table-name"), (String[])null), new SqlFilterDefComponent("description", this.stringManager.getString("description"), (String[])null), new SqlFilterDefComponent("validated = 'N'", this.stringManager.getString("constraint-not-valid")), new SqlFilterDefComponent("constraint_name is not null", this.stringManager.getString("constraint-only-named"))};
    }

    public String getTitle() {
        return this.stringManager.getString("constraints");
    }
}

