/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.postgresql.gui.tables;

import javax.swing.table.TableCellRenderer;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.postgresql.OrbadaPostgreSQLPlugin;
import pl.mpak.orbada.postgresql.Sql;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.tabbed.UniversalPropTab;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableCellRendererFilter;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.crf.YesNoCellRendererFilter;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class TableIndexListTab
extends UniversalPropTab {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaPostgreSQLPlugin.class);

    public TableIndexListTab(IViewAccesibilities accesibilities) {
        super(accesibilities);
    }

    public String getPanelName() {
        return "postgresql-table-indexes";
    }

    public String getObjectColumnName() {
        return "table_name";
    }

    public String getSchemaColumnName() {
        return "schema_name";
    }

    public String getPropColumnName() {
        return "index_name";
    }

    public QueryTableColumn[] getTableColumns() {
        return new QueryTableColumn[]{new QueryTableColumn("index_name", this.stringManager.getString("index-name"), 130, (TableCellRenderer)new QueryTableCellRenderer(1)), new QueryTableColumn("table_space", this.stringManager.getString("table-space"), 130), new QueryTableColumn("method", this.stringManager.getString("index-method"), 130, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.GREEN)), new QueryTableColumn("index_expr", this.stringManager.getString("index-expression"), 130), new QueryTableColumn("uniqueness", this.stringManager.getString("index-uniqueness"), 30, (TableCellRenderer)new QueryTableCellRenderer((QueryTableCellRendererFilter)new YesNoCellRendererFilter(SwingUtil.Color.GREEN, null))), new QueryTableColumn("clustered", this.stringManager.getString("clustered"), 30, (TableCellRenderer)new QueryTableCellRenderer((QueryTableCellRendererFilter)new YesNoCellRendererFilter(SwingUtil.Color.GREEN, null))), new QueryTableColumn("index_pk", this.stringManager.getString("primary-key"), 30, (TableCellRenderer)new QueryTableCellRenderer((QueryTableCellRendererFilter)new YesNoCellRendererFilter(SwingUtil.Color.GREEN, null))), new QueryTableColumn("description", this.stringManager.getString("description"), 250)};
    }

    public String getSql(SqlFilter filter) {
        return Sql.getIndexList(filter.getSqlText());
    }

    public SqlFilterDefComponent[] getFilterDefComponent() {
        return new SqlFilterDefComponent[]{new SqlFilterDefComponent("index_name", this.stringManager.getString("index-name"), (String[])null), new SqlFilterDefComponent("table_space", this.stringManager.getString("table-space"), (String[])null), new SqlFilterDefComponent("method", this.stringManager.getString("index-method"), (String[])null), new SqlFilterDefComponent("index_expr", this.stringManager.getString("index-expression"), (String[])null), new SqlFilterDefComponent("description", this.stringManager.getString("description"), (String[])null), new SqlFilterDefComponent("uniqueness = 'Y'", this.stringManager.getString("index-uniqueness")), new SqlFilterDefComponent("index_pk <> 'Y'", this.stringManager.getString("not-primary-key"))};
    }

    public String getTitle() {
        return this.stringManager.getString("indexes");
    }
}

