/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.postgresql.gui.tables;

import javax.swing.table.TableCellRenderer;
import pl.mpak.orbada.gui.comps.OrbadaSyntaxTextArea;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.postgresql.OrbadaPostgreSQLPlugin;
import pl.mpak.orbada.postgresql.Sql;
import pl.mpak.orbada.postgresql.util.SourceCreator;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.tabbed.UniversalPropSourceTab;
import pl.mpak.sky.gui.swing.syntax.SyntaxTextArea;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class TableTriggerFunctionSourceTab
extends UniversalPropSourceTab {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaPostgreSQLPlugin.class);

    public TableTriggerFunctionSourceTab(IViewAccesibilities accesibilities) {
        super(accesibilities);
    }

    public String getPanelName() {
        return "postgresql-table-trigger-functions";
    }

    public String getObjectColumnName() {
        return "object_name";
    }

    public String getSchemaColumnName() {
        return "schema_name";
    }

    public String getPropColumnName() {
        return "function_name";
    }

    public QueryTableColumn[] getTableColumns() {
        return new QueryTableColumn[]{new QueryTableColumn("function_schema_name", this.stringManager.getString("schema-name"), 130), new QueryTableColumn("function_name", this.stringManager.getString("function-name"), 130, (TableCellRenderer)new QueryTableCellRenderer(1)), new QueryTableColumn("function_arguments", this.stringManager.getString("function-arguments"), 130), new QueryTableColumn("triggers", this.stringManager.getString("triggers"), 250)};
    }

    public String getSql(SqlFilter filter) {
        return Sql.getTriggerFunctionList(filter.getSqlText());
    }

    public SqlFilterDefComponent[] getFilterDefComponent() {
        return new SqlFilterDefComponent[]{new SqlFilterDefComponent("function_schema_name", this.stringManager.getString("schema-name"), (String[])null), new SqlFilterDefComponent("function_name", this.stringManager.getString("function-name"), (String[])null), new SqlFilterDefComponent("triggers", this.stringManager.getString("triggers"), (String[])null)};
    }

    public void updateBody(OrbadaSyntaxTextArea textArea) {
        try {
            String functionSchema = this.getQuery().fieldByName("function_schema_name").getString();
            String functionName = this.getQuery().fieldByName("full_function_name").getString();
            new SourceCreator(this.getDatabase(), (SyntaxTextArea)textArea).getSource(functionSchema, "FUNCTION", functionName, null);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public String getTitle() {
        return this.stringManager.getString("trigger-functions");
    }
}

