/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.postgresql.gui.triggers;

import java.util.HashMap;
import pl.mpak.orbada.gui.ITabObjectUserData;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.postgresql.Sql;
import pl.mpak.orbada.postgresql.gui.PostgreSQLDependsTab;
import pl.mpak.orbada.postgresql.services.PostgreSQLDbInfoProvider;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.core.ParametrizedCommand;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.variant.Variant;

public class TriggerDependsTab
extends PostgreSQLDependsTab
implements ITabObjectUserData {
    private HashMap<String, Variant> mapValues;

    public TriggerDependsTab(IViewAccesibilities accesibilities) {
        super(accesibilities);
    }

    public String getSql(SqlFilter filter) {
        return Sql.getDependTriggerList(filter.getSqlText(), PostgreSQLDbInfoProvider.instance.getVersion(this.getDatabase()));
    }

    public void userData(HashMap<String, Variant> values) {
        this.mapValues = values;
    }

    public void extraSqlParameters(ParametrizedCommand qc) throws UseDBException {
        super.extraSqlParameters(qc);
        try {
            if (this.mapValues != null) {
                qc.paramByName("table_name").setString(this.mapValues.get("table_name").getString());
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }
}

