/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.postgresql.gui.triggers;

import java.util.HashMap;
import pl.mpak.orbada.gui.ITabObjectUserData;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.postgresql.OrbadaPostgreSQLPlugin;
import pl.mpak.orbada.postgresql.Sql;
import pl.mpak.orbada.universal.gui.tabbed.UniversalPropDetailsTab;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.core.ParametrizedCommand;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.variant.Variant;

public class TriggerDetailsTab
extends UniversalPropDetailsTab
implements ITabObjectUserData {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaPostgreSQLPlugin.class);
    private HashMap<String, Variant> mapValues;

    public TriggerDetailsTab(IViewAccesibilities accesibilities) {
        super(accesibilities);
    }

    public String getPanelName() {
        return "postgresql-trigger-details";
    }

    public String getSql() {
        return Sql.getTriggerDetail();
    }

    public void userData(HashMap<String, Variant> values) {
        this.mapValues = values;
    }

    public void extraSqlParameters(ParametrizedCommand qc) throws UseDBException {
        try {
            if (this.mapValues != null) {
                qc.paramByName("schema_name").setString(this.currentSchemaName);
                qc.paramByName("trigger_name").setString(this.currentObjectName);
                qc.paramByName("table_name").setString(this.mapValues.get("table_name").getString());
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public String getTitle() {
        return this.stringManager.getString("details");
    }
}

