/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.postgresql.gui.triggers;

import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.postgresql.OrbadaPostgreSQLPlugin;
import pl.mpak.orbada.postgresql.Sql;
import pl.mpak.orbada.postgresql.gui.triggers.TriggerTabbedPane;
import pl.mpak.orbada.postgresql.services.PostgreSQLDbInfoProvider;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.tabbed.UniversalViewTabs;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.core.ParametrizedCommand;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableCellRendererFilter;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.variant.Variant;

public class TriggerListView
extends UniversalViewTabs {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaPostgreSQLPlugin.class);

    public TriggerListView(IViewAccesibilities accesibilities) {
        super(accesibilities);
    }

    public Component getTabbedPane() {
        return new TriggerTabbedPane(this.accesibilities);
    }

    public String getCurrentSchemaName() {
        return PostgreSQLDbInfoProvider.getConnectedSchema(this.getDatabase());
    }

    public String getPanelName() {
        return "postgresql-triggers";
    }

    public String getObjectColumnName() {
        return "trigger_name";
    }

    public String getSchemaColumnName() {
        return "schema_name";
    }

    public String getDescriptionColumnName() {
        return "description";
    }

    public String getSql(SqlFilter filter) {
        return Sql.getTriggerList(filter.getSqlText());
    }

    protected void extraSqlParameters(ParametrizedCommand qc) throws UseDBException {
        qc.paramByName("object_name").setString(null);
    }

    protected HashMap<String, Variant> getUserData() {
        HashMap<String, Variant> map = new HashMap<String, Variant>();
        try {
            map.put("table_name", new Variant(this.getQuery().fieldByName("object_name").getString()));
            map.put("full_function_name", new Variant(this.getQuery().fieldByName("full_function_name").getString()));
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        return map;
    }

    public QueryTableColumn[] getTableColumns() {
        return new QueryTableColumn[]{new QueryTableColumn("schema_name", this.stringManager.getString("schema-name"), 130, (TableCellRenderer)new QueryTableCellRenderer(1)), new QueryTableColumn("trigger_name", this.stringManager.getString("trigger-name"), 130, (TableCellRenderer)new QueryTableCellRenderer(1)), new QueryTableColumn("object_name", this.stringManager.getString("object-name"), 130), new QueryTableColumn("enable_mode", this.stringManager.getString("trigger-enable-mode"), 130, (TableCellRenderer)new QueryTableCellRenderer(new QueryTableCellRendererFilter(){

            public void cellRendererPerformed(JTable table, Component renderer, Object value, boolean isSelected, boolean hasFocus) {
                if (StringUtil.nvl((String)((String)value), (String)"").equals("DISABLED")) {
                    ((JLabel)renderer).setForeground(Color.DARK_GRAY);
                } else if (StringUtil.nvl((String)((String)value), (String)"").equals("ENABLED")) {
                    ((JLabel)renderer).setForeground(SwingUtil.Color.GREEN);
                }
            }
        })), new QueryTableColumn("action_timing", this.stringManager.getString("trigger-action-timing"), 130), new QueryTableColumn("trigger_event", this.stringManager.getString("trigger-trigger-event"), 150), new QueryTableColumn("full_function_name", this.stringManager.getString("trigger-function-call"), 150), new QueryTableColumn("description", this.stringManager.getString("description"), 250)};
    }

    public SqlFilterDefComponent[] getFilterDefComponent() {
        return new SqlFilterDefComponent[]{new SqlFilterDefComponent("trigger_name", this.stringManager.getString("trigger-name"), (String[])null), new SqlFilterDefComponent("object_name", this.stringManager.getString("object-name"), (String[])null), new SqlFilterDefComponent("enable_mode", this.stringManager.getString("trigger-enable-mode"), new String[]{"'ENABLED'", "'DISABLED'", "'REPLICA'", "'ALWAYS'"}), new SqlFilterDefComponent("action_timing", this.stringManager.getString("trigger-action-timing"), (String[])null), new SqlFilterDefComponent("trigger_event", this.stringManager.getString("trigger-trigger-event"), (String[])null), new SqlFilterDefComponent("function_call", this.stringManager.getString("trigger-function-call"), (String[])null), new SqlFilterDefComponent("description", this.stringManager.getString("description"), (String[])null)};
    }

    public String[] getSchemaList() {
        return PostgreSQLDbInfoProvider.instance.getSchemas(this.getDatabase());
    }
}

