/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.postgresql.gui.types;

import javax.swing.table.TableCellRenderer;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.postgresql.OrbadaPostgreSQLPlugin;
import pl.mpak.orbada.postgresql.Sql;
import pl.mpak.orbada.postgresql.services.PostgreSQLDbInfoProvider;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.tabbed.UniversalPropTab;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class TypeAttributeListTab
extends UniversalPropTab {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaPostgreSQLPlugin.class);

    public TypeAttributeListTab(IViewAccesibilities accesibilities) {
        super(accesibilities);
    }

    public String getPanelName() {
        return "postgresql-type-attributes";
    }

    public String getObjectColumnName() {
        return "type_name";
    }

    public String getSchemaColumnName() {
        return "schema_name";
    }

    public String getPropColumnName() {
        return "att_no";
    }

    public String getSql(SqlFilter filter) {
        return Sql.getTypeAttributeList(filter.getSqlText(), PostgreSQLDbInfoProvider.instance.getVersion(this.getDatabase()));
    }

    public QueryTableColumn[] getTableColumns() {
        return new QueryTableColumn[]{new QueryTableColumn("att_no", this.stringManager.getString("ordinal"), 30), new QueryTableColumn("attribute_name", this.stringManager.getString("attribute-name"), 130, (TableCellRenderer)new QueryTableCellRenderer(1)), new QueryTableColumn("display_datatype", this.stringManager.getString("data-type"), 130, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.GREEN)), new QueryTableColumn("att_collation", this.stringManager.getString("collation"), 100)};
    }

    public SqlFilterDefComponent[] getFilterDefComponent() {
        return new SqlFilterDefComponent[]{new SqlFilterDefComponent("attribute_name", this.stringManager.getString("attribute-name"), (String[])null), new SqlFilterDefComponent("display_datatype", this.stringManager.getString("data-type"), (String[])null), new SqlFilterDefComponent("att_collation", this.stringManager.getString("collation"), (String[])null)};
    }

    public String getTitle() {
        return this.stringManager.getString("type-attributes");
    }
}

