/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.postgresql.gui.types;

import java.awt.Component;
import javax.swing.table.TableCellRenderer;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.postgresql.OrbadaPostgreSQLPlugin;
import pl.mpak.orbada.postgresql.Sql;
import pl.mpak.orbada.postgresql.gui.types.TypeTabbedPane;
import pl.mpak.orbada.postgresql.services.PostgreSQLDbInfoProvider;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.tabbed.UniversalViewTabs;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class TypeListView
extends UniversalViewTabs {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaPostgreSQLPlugin.class);

    public TypeListView(IViewAccesibilities accesibilities) {
        super(accesibilities);
    }

    public Component getTabbedPane() {
        return new TypeTabbedPane(this.accesibilities);
    }

    public String getCurrentSchemaName() {
        return PostgreSQLDbInfoProvider.getConnectedSchema(this.getDatabase());
    }

    public String getPanelName() {
        return "postgresql-types";
    }

    public String getObjectColumnName() {
        return "type_name";
    }

    public String getSchemaColumnName() {
        return "schema_name";
    }

    public String getDescriptionColumnName() {
        return "description";
    }

    public String getSql(SqlFilter filter) {
        return Sql.getTypeList(filter.getSqlText(), PostgreSQLDbInfoProvider.instance.getVersion(this.getDatabase()));
    }

    public QueryTableColumn[] getTableColumns() {
        return new QueryTableColumn[]{new QueryTableColumn("schema_name", this.stringManager.getString("schema-name"), 130, (TableCellRenderer)new QueryTableCellRenderer(1)), new QueryTableColumn("type_name", this.stringManager.getString("type-name"), 130, (TableCellRenderer)new QueryTableCellRenderer(1)), new QueryTableColumn("owner_name", this.stringManager.getString("owner-name"), 130), new QueryTableColumn("display_type", this.stringManager.getString("display-type"), 100, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.GREEN)), new QueryTableColumn("description", this.stringManager.getString("description"), 250)};
    }

    public SqlFilterDefComponent[] getFilterDefComponent() {
        return new SqlFilterDefComponent[]{new SqlFilterDefComponent("type_name", this.stringManager.getString("function-name"), (String[])null), new SqlFilterDefComponent("owner_name", this.stringManager.getString("owner-name"), (String[])null), new SqlFilterDefComponent("description", this.stringManager.getString("description"), (String[])null), new SqlFilterDefComponent("display_type", this.stringManager.getString("display-type"), (String[])null)};
    }

    public String[] getSchemaList() {
        return PostgreSQLDbInfoProvider.instance.getSchemas(this.getDatabase());
    }
}

