/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.postgresql.gui.util;

import java.awt.Component;
import javax.swing.table.TableCellRenderer;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.postgresql.OrbadaPostgreSQLPlugin;
import pl.mpak.orbada.postgresql.Sql;
import pl.mpak.orbada.postgresql.services.PostgreSQLDbInfoProvider;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.tabbed.UniversalViewTabs;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.SearchEvent;
import pl.mpak.sky.gui.swing.comp.SearchListener;
import pl.mpak.sky.gui.swing.comp.SearchPanel;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.core.ParametrizedCommand;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class SearchObjectPanelView
extends UniversalViewTabs {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaPostgreSQLPlugin.class);
    private SearchPanel searchPanel;

    public SearchObjectPanelView(IViewAccesibilities accesibilities) {
        super(accesibilities);
    }

    protected void init() {
        this.searchPanel = new SearchPanel();
        this.searchPanel.setTable(this.getTable());
        this.searchPanel.addSearchListener(new SearchListener(){

            public void search(SearchEvent e) {
                SearchObjectPanelView.this.refresh();
            }
        });
        this.getToolBar().add((Component)this.searchPanel);
        super.init();
    }

    public Component getTabbedPane() {
        return null;
    }

    public String getCurrentSchemaName() {
        return PostgreSQLDbInfoProvider.getConnectedSchema(this.getDatabase());
    }

    public String getPanelName() {
        return "postgresql-search-objects";
    }

    public String getSchemaColumnName() {
        return "schema_name";
    }

    public String getObjectColumnName() {
        return "object_name";
    }

    public String getDescriptionColumnName() {
        return null;
    }

    public QueryTableColumn[] getTableColumns() {
        return new QueryTableColumn[]{new QueryTableColumn("tablespace_name", this.stringManager.getString("tablespace-name"), 150), new QueryTableColumn("owner_name", this.stringManager.getString("owner-name"), 150), new QueryTableColumn("object_type", this.stringManager.getString("object-type"), 150, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.GREEN)), new QueryTableColumn("object_owner", this.stringManager.getString("object-owner"), 150), new QueryTableColumn("object_name", this.stringManager.getString("object-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)), new QueryTableColumn("object_attribute", this.stringManager.getString("object-attribute"), 150), new QueryTableColumn("object_info", this.stringManager.getString("object-info"), 150), new QueryTableColumn("description", this.stringManager.getString("description"), 250)};
    }

    public String getSql(SqlFilter filter) {
        return Sql.getSearchObjectList(filter.getSqlText(), PostgreSQLDbInfoProvider.instance.getVersion(this.getDatabase()));
    }

    public SqlFilterDefComponent[] getFilterDefComponent() {
        return new SqlFilterDefComponent[]{new SqlFilterDefComponent("object_name", this.stringManager.getString("object-name"), (String[])null), new SqlFilterDefComponent("object_type", this.stringManager.getString("object-type"), new String[]{"('INDEX', 'CONSTRAINT', 'COMPOSITE TYPE', 'BASE TYPE')"}), new SqlFilterDefComponent("owner_name", this.stringManager.getString("owner-name"), (String[])null), new SqlFilterDefComponent("tablespace_name", this.stringManager.getString("tablespace-name"), (String[])null), new SqlFilterDefComponent("object_attribute", this.stringManager.getString("object-attribute"), (String[])null), new SqlFilterDefComponent("object_info", this.stringManager.getString("object-info"), (String[])null), new SqlFilterDefComponent("object_owner", this.stringManager.getString("object-owner"), (String[])null), new SqlFilterDefComponent("description", this.stringManager.getString("description"), (String[])null)};
    }

    public String[] getSchemaList() {
        return PostgreSQLDbInfoProvider.instance.getSchemas(this.getDatabase());
    }

    public void extraSqlParameters(ParametrizedCommand qc) throws UseDBException {
        qc.paramByName("search_text").setString(this.searchPanel.getText());
    }

    public boolean canOpen(ParametrizedCommand qc) {
        return !"".equals(this.searchPanel.getText());
    }
}

