/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.postgresql.gui.util;

import java.awt.Component;
import java.util.HashMap;
import javax.swing.table.TableCellRenderer;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.postgresql.OrbadaPostgreSQLPlugin;
import pl.mpak.orbada.postgresql.Sql;
import pl.mpak.orbada.postgresql.gui.util.SearchSourceSourcePanel;
import pl.mpak.orbada.postgresql.services.PostgreSQLDbInfoProvider;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.tabbed.UniversalViewTabs;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.SearchEvent;
import pl.mpak.sky.gui.swing.comp.SearchListener;
import pl.mpak.sky.gui.swing.comp.SearchPanel;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.core.ParametrizedCommand;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.variant.Variant;

public class SearchSourcePanelView
extends UniversalViewTabs {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaPostgreSQLPlugin.class);
    private SearchPanel searchPanel;

    public SearchSourcePanelView(IViewAccesibilities accesibilities) {
        super(accesibilities);
    }

    protected void init() {
        this.searchPanel = new SearchPanel();
        this.searchPanel.setTable(this.getTable());
        this.searchPanel.addSearchListener(new SearchListener(){

            public void search(SearchEvent e) {
                SearchSourcePanelView.this.refresh();
            }
        });
        this.getToolBar().add((Component)this.searchPanel);
        super.init();
    }

    public boolean isHorizontal() {
        return false;
    }

    public Component getTabbedPane() {
        return new SearchSourceSourcePanel(this.accesibilities);
    }

    public String getCurrentSchemaName() {
        return PostgreSQLDbInfoProvider.getConnectedSchema(this.getDatabase());
    }

    public String getPanelName() {
        return "postgresql-search-sources";
    }

    public String getSchemaColumnName() {
        return "schema_name";
    }

    public String getObjectColumnName() {
        return "object_name";
    }

    public String getDescriptionColumnName() {
        return null;
    }

    protected HashMap<String, Variant> getUserData() {
        HashMap<String, Variant> map = new HashMap<String, Variant>();
        try {
            map.put("object_type", new Variant(this.getQuery().fieldByName("object_type").getString()));
            map.put("object_owner", new Variant(this.getQuery().fieldByName("object_owner").getString()));
            map.put("line", new Variant(this.getQuery().fieldByName("line").getInteger()));
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        return map;
    }

    public String getSql(SqlFilter filter) {
        return Sql.getSearchSourceList(filter.getSqlText(), PostgreSQLDbInfoProvider.instance.getVersion(this.getDatabase()));
    }

    public QueryTableColumn[] getTableColumns() {
        return new QueryTableColumn[]{new QueryTableColumn("schema_name", this.stringManager.getString("schema-name"), 150), new QueryTableColumn("owner_name", this.stringManager.getString("owner-name"), 150), new QueryTableColumn("object_type", this.stringManager.getString("object-type"), 150, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.GREEN)), new QueryTableColumn("object_name", this.stringManager.getString("object-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)), new QueryTableColumn("line", this.stringManager.getString("line-no"), 70), new QueryTableColumn("source_line", this.stringManager.getString("source-line"), 450)};
    }

    public SqlFilterDefComponent[] getFilterDefComponent() {
        return new SqlFilterDefComponent[]{new SqlFilterDefComponent("owner_name", this.stringManager.getString("owner-name"), (String[])null), new SqlFilterDefComponent("object_name", this.stringManager.getString("object-name"), (String[])null), new SqlFilterDefComponent("object_type", this.stringManager.getString("object-type"), (String[])null)};
    }

    public String[] getSchemaList() {
        return PostgreSQLDbInfoProvider.instance.getSchemas(this.getDatabase());
    }

    public void extraSqlParameters(ParametrizedCommand qc) throws UseDBException {
        qc.paramByName("search_text").setString(this.searchPanel.getText());
    }

    public boolean canOpen(ParametrizedCommand qc) {
        return !"".equals(this.searchPanel.getText());
    }
}

