/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.postgresql.gui.util;

import java.awt.Component;
import java.util.HashMap;
import pl.mpak.orbada.gui.ITabObjectUserData;
import pl.mpak.orbada.gui.comps.AbsOrbadaSyntaxTextArea;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.postgresql.OrbadaPostgreSQLPlugin;
import pl.mpak.orbada.postgresql.util.SourceCreator;
import pl.mpak.orbada.universal.gui.tabbed.UniversalSourceTab;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.variant.Variant;

public class SearchSourceSourcePanel
extends UniversalSourceTab
implements ITabObjectUserData {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaPostgreSQLPlugin.class);
    private HashMap<String, String> sourceMap = new HashMap();
    protected String lastSchemaName = "";
    protected String lastObjectName = "";
    private HashMap<String, Variant> mapValues;

    public SearchSourceSourcePanel(IViewAccesibilities accesibilities) {
        super(accesibilities);
    }

    public String getPanelName() {
        return "postgresql-search-source";
    }

    protected boolean isToolbar() {
        return false;
    }

    public void refresh(String catalogName, String schemaName, String objectName) {
        if (!this.currentSchemaName.equals(schemaName) || !this.currentObjectName.equals(objectName) || this.requestRefresh) {
            super.refresh(catalogName, schemaName, objectName);
        } else if (SwingUtil.isVisible((Component)((Object)this))) {
            this.updateBody(this.getTextArea());
        }
    }

    public void userData(HashMap<String, Variant> values) {
        this.mapValues = values;
    }

    public void updateBody(AbsOrbadaSyntaxTextArea textArea) {
        if (!StringUtil.isEmpty((String)this.currentObjectName) && this.mapValues != null) {
            if (!StringUtil.equals((String)this.currentSchemaName, (String)this.lastSchemaName)) {
                this.sourceMap.clear();
                this.lastSchemaName = this.currentSchemaName;
            }
            String objectType = null;
            String objectOwner = null;
            int line = 0;
            try {
                objectType = this.mapValues.get("object_type").getString();
                objectOwner = this.mapValues.get("object_owner").getString();
                line = this.mapValues.get("line").getInteger();
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
            String source = null;
            if (!StringUtil.equals((String)this.currentObjectName, (String)this.lastObjectName)) {
                source = this.sourceMap.get(this.currentObjectName);
                if (source == null) {
                    source = new SourceCreator(this.accesibilities.getDatabase()).getSource(this.currentSchemaName, objectType, this.currentObjectName, objectOwner);
                    this.sourceMap.put(this.currentObjectName, source);
                }
                this.lastObjectName = this.currentObjectName;
                this.getTextArea().setDatabaseObject(this.currentSchemaName, objectType, this.currentObjectName, source);
            }
            if ("VIEW".equalsIgnoreCase(objectType)) {
                ++line;
            } else if ("RULE".equalsIgnoreCase(objectType)) {
                line += 2;
            } else if ("TRIGGER".equalsIgnoreCase(objectType)) {
                line += 2;
            }
            this.gotoPoint(line + 2, 1);
        }
    }

    public boolean isStorable() {
        return false;
    }

    public String getTitle() {
        return null;
    }
}

