/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.postgresql.gui.views;

import java.awt.Color;
import java.awt.Component;
import javax.swing.table.TableCellRenderer;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.postgresql.OrbadaPostgreSQLPlugin;
import pl.mpak.orbada.postgresql.Sql;
import pl.mpak.orbada.postgresql.gui.views.ViewTabbedPane;
import pl.mpak.orbada.postgresql.services.PostgreSQLDbInfoProvider;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.tabbed.UniversalViewTabs;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableCellRendererFilter;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.crf.ColorListCellRendererFilter;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class ViewListView
extends UniversalViewTabs {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaPostgreSQLPlugin.class);

    public ViewListView(IViewAccesibilities accesibilities) {
        super(accesibilities);
    }

    public Component getTabbedPane() {
        return new ViewTabbedPane(this.accesibilities);
    }

    public String getCurrentSchemaName() {
        return PostgreSQLDbInfoProvider.getConnectedSchema(this.getDatabase());
    }

    public String getPanelName() {
        return "postgresql-views";
    }

    public String getObjectColumnName() {
        return "view_name";
    }

    public String getSchemaColumnName() {
        return "schema_name";
    }

    public String getDescriptionColumnName() {
        return "description";
    }

    public QueryTableColumn[] getTableColumns() {
        return new QueryTableColumn[]{new QueryTableColumn("schema_name", this.stringManager.getString("schema-name"), 130, (TableCellRenderer)new QueryTableCellRenderer(1)), new QueryTableColumn("view_name", this.stringManager.getString("view-name"), 130, (TableCellRenderer)new QueryTableCellRenderer(1)), new QueryTableColumn("owner_name", this.stringManager.getString("owner-name"), 130), new QueryTableColumn("accessible", this.stringManager.getString("accessible"), 100, (TableCellRenderer)new QueryTableCellRenderer((QueryTableCellRendererFilter)new ColorListCellRendererFilter(new String[]{"NO"}, new Color[]{Color.RED}))), new QueryTableColumn("description", this.stringManager.getString("description"), 250)};
    }

    public String getSql(SqlFilter filter) {
        return Sql.getViewList(filter.getSqlText());
    }

    public SqlFilterDefComponent[] getFilterDefComponent() {
        return new SqlFilterDefComponent[]{new SqlFilterDefComponent("view_name", this.stringManager.getString("view-name"), (String[])null), new SqlFilterDefComponent("owner_name", this.stringManager.getString("owner-name"), (String[])null), new SqlFilterDefComponent("description", this.stringManager.getString("description"), (String[])null), new SqlFilterDefComponent("accessible", this.stringManager.getString("accessible"), (String[])null)};
    }

    public String[] getSchemaList() {
        return PostgreSQLDbInfoProvider.instance.getSchemas(this.getDatabase());
    }
}

