/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.postgresql.gui.views;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import pl.mpak.orbada.gui.comps.OrbadaSyntaxTextArea;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.postgresql.OrbadaPostgreSQLPlugin;
import pl.mpak.orbada.postgresql.Sql;
import pl.mpak.orbada.postgresql.util.SourceCreator;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.tabbed.UniversalPropSourceTab;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.syntax.SyntaxTextArea;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableCellRendererFilter;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.crf.YesNoCellRendererFilter;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class ViewRuleSourceTab
extends UniversalPropSourceTab {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaPostgreSQLPlugin.class);

    public ViewRuleSourceTab(IViewAccesibilities accesibilities) {
        super(accesibilities);
    }

    public String getPanelName() {
        return "postgresql-view-rules";
    }

    public String getObjectColumnName() {
        return "object_name";
    }

    public String getSchemaColumnName() {
        return "schema_name";
    }

    public String getPropColumnName() {
        return "rule_name";
    }

    public QueryTableColumn[] getTableColumns() {
        return new QueryTableColumn[]{new QueryTableColumn("rule_name", this.stringManager.getString("rule-name"), 130, (TableCellRenderer)new QueryTableCellRenderer(1)), new QueryTableColumn("enable_mode", this.stringManager.getString("rule-enable-mode"), 130, (TableCellRenderer)new QueryTableCellRenderer(new QueryTableCellRendererFilter(){

            public void cellRendererPerformed(JTable table, Component renderer, Object value, boolean isSelected, boolean hasFocus) {
                if (StringUtil.nvl((String)((String)value), (String)"").equals("DISABLED")) {
                    ((JLabel)renderer).setForeground(Color.DARK_GRAY);
                } else if (StringUtil.nvl((String)((String)value), (String)"").equals("ENABLED")) {
                    ((JLabel)renderer).setForeground(SwingUtil.Color.GREEN);
                }
            }
        })), new QueryTableColumn("rule_type", this.stringManager.getString("rule-type"), 130), new QueryTableColumn("is_instead", this.stringManager.getString("rule-is-instead"), 30, (TableCellRenderer)new QueryTableCellRenderer((QueryTableCellRendererFilter)new YesNoCellRendererFilter(null, null))), new QueryTableColumn("description", this.stringManager.getString("description"), 250)};
    }

    public String getSql(SqlFilter filter) {
        return Sql.getRuleList(filter.getSqlText());
    }

    public SqlFilterDefComponent[] getFilterDefComponent() {
        return new SqlFilterDefComponent[]{new SqlFilterDefComponent("rule_name", this.stringManager.getString("rule-name"), (String[])null), new SqlFilterDefComponent("enable_mode", this.stringManager.getString("rule-enable-mode"), new String[]{"'ENABLED'", "'DISABLED'", "'REPLICA'", "'ALWAYS'"}), new SqlFilterDefComponent("rule_type", this.stringManager.getString("rule-type"), (String[])null), new SqlFilterDefComponent("is_instead = 'Y'", this.stringManager.getString("rule-is-instead")), new SqlFilterDefComponent("description", this.stringManager.getString("description"), (String[])null)};
    }

    public void updateBody(OrbadaSyntaxTextArea textArea) {
        new SourceCreator(this.getDatabase(), (SyntaxTextArea)textArea).getSource(this.currentSchemaName, "RULE", this.currentPropName, this.currentObjectName);
    }

    public String getTitle() {
        return this.stringManager.getString("rules");
    }
}

