/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.postgresql.gui.views;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import pl.mpak.orbada.gui.comps.OrbadaSyntaxTextArea;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.postgresql.OrbadaPostgreSQLPlugin;
import pl.mpak.orbada.postgresql.Sql;
import pl.mpak.orbada.postgresql.util.SourceCreator;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.tabbed.UniversalPropSourceTab;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.syntax.SyntaxTextArea;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableCellRendererFilter;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class ViewTriggerSourceTab
extends UniversalPropSourceTab {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaPostgreSQLPlugin.class);

    public ViewTriggerSourceTab(IViewAccesibilities accesibilities) {
        super(accesibilities);
    }

    public String getPanelName() {
        return "postgresql-view-triggers";
    }

    public String getObjectColumnName() {
        return "object_name";
    }

    public String getSchemaColumnName() {
        return "schema_name";
    }

    public String getPropColumnName() {
        return "trigger_name";
    }

    public QueryTableColumn[] getTableColumns() {
        return new QueryTableColumn[]{new QueryTableColumn("trigger_name", this.stringManager.getString("trigger-name"), 130, (TableCellRenderer)new QueryTableCellRenderer(1)), new QueryTableColumn("enable_mode", this.stringManager.getString("trigger-enable-mode"), 130, (TableCellRenderer)new QueryTableCellRenderer(new QueryTableCellRendererFilter(){

            public void cellRendererPerformed(JTable table, Component renderer, Object value, boolean isSelected, boolean hasFocus) {
                if (StringUtil.nvl((String)((String)value), (String)"").equals("DISABLED")) {
                    ((JLabel)renderer).setForeground(Color.DARK_GRAY);
                } else if (StringUtil.nvl((String)((String)value), (String)"").equals("ENABLED")) {
                    ((JLabel)renderer).setForeground(SwingUtil.Color.GREEN);
                }
            }
        })), new QueryTableColumn("action_timing", this.stringManager.getString("trigger-action-timing"), 130), new QueryTableColumn("trigger_event", this.stringManager.getString("trigger-trigger-event"), 150), new QueryTableColumn("full_function_name", this.stringManager.getString("trigger-function-call"), 150), new QueryTableColumn("description", this.stringManager.getString("description"), 250)};
    }

    public String getSql(SqlFilter filter) {
        return Sql.getTriggerList(filter.getSqlText());
    }

    public SqlFilterDefComponent[] getFilterDefComponent() {
        return new SqlFilterDefComponent[]{new SqlFilterDefComponent("trigger_name", this.stringManager.getString("trigger-name"), (String[])null), new SqlFilterDefComponent("enable_mode", this.stringManager.getString("trigger-enable-mode"), new String[]{"'ENABLED'", "'DISABLED'", "'REPLICA'", "'ALWAYS'"}), new SqlFilterDefComponent("action_timing", this.stringManager.getString("trigger-action-timing"), (String[])null), new SqlFilterDefComponent("trigger_event", this.stringManager.getString("trigger-trigger-event"), (String[])null), new SqlFilterDefComponent("function_call", this.stringManager.getString("trigger-function-call"), (String[])null), new SqlFilterDefComponent("description", this.stringManager.getString("description"), (String[])null)};
    }

    public void updateBody(OrbadaSyntaxTextArea textArea) {
        new SourceCreator(this.getDatabase(), (SyntaxTextArea)textArea).getSource(this.currentSchemaName, "TRIGGER", this.currentPropName, this.currentObjectName);
    }

    public String getTitle() {
        return this.stringManager.getString("triggers");
    }
}

