/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.postgresql.gui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.postgresql.OrbadaPostgreSQLPlugin;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class CommentUniversalWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaPostgreSQLPlugin.class);
    private Database database;
    private String objectType;
    private String fullObjectName;
    private String typeStringBundle;
    private String description;
    private JLabel jLabel3;
    private JLabel labelObject;
    private TextField textComments;
    private TextField textObject;

    public CommentUniversalWizard(Database database, String typeStringBundle, String objectType, String fullObjectName, String description) {
        this.database = database;
        this.typeStringBundle = typeStringBundle;
        this.objectType = objectType;
        this.fullObjectName = fullObjectName;
        this.description = description;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.labelObject.setText(this.stringManager.getString(this.typeStringBundle));
        this.textComments.setText(this.description);
        this.textObject.setText(this.fullObjectName);
    }

    public void wizardShow() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CommentUniversalWizard.this.textComments.requestFocusInWindow();
            }
        });
    }

    public String getDialogTitle() {
        return this.stringManager.getString("comment-edit");
    }

    public String getTabTitle() {
        return this.stringManager.getString("comment");
    }

    public String getSqlCode() {
        return "COMMENT ON " + this.objectType + " " + this.textObject.getText() + " IS '" + StringUtil.replaceString((String)this.textComments.getText(), (String)"'", (String)"''") + "'";
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.labelObject = new JLabel();
        this.jLabel3 = new JLabel();
        this.textObject = new TextField();
        this.textComments = new TextField();
        this.labelObject.setHorizontalAlignment(4);
        this.labelObject.setText("ObjectName:");
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("comment-dd"));
        this.textObject.setEnabled(false);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.labelObject, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textObject, -1, 275, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textComments, -1, 275, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelObject).addComponent((Component)this.textObject, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this.textComments, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

