/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.postgresql.services;

import pl.mpak.orbada.plugins.providers.DatabaseProvider;
import pl.mpak.orbada.postgresql.OrbadaPostgreSQLPlugin;
import pl.mpak.orbada.postgresql.Sql;
import pl.mpak.orbada.postgresql.services.PostgreSQLDbInfoProvider;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class PostgreSQLDatabaseProvider
extends DatabaseProvider {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaPostgreSQLPlugin.class);

    public boolean isForDatabase(Database database) {
        if (database == null) {
            return false;
        }
        return "PostgreSQL".equals(database.getDriverType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterConnection(Database database) {
        Query query = database.createQuery();
        try {
            database.executeCommand(Sql.getSetAppInfo());
            query.open(Sql.getCurrentSchema());
            database.getUserProperties().put("schema-name", query.fieldByName("schema_name").getString());
            database.getUserProperties().put("dict-persistent-query", "true");
            query.open(Sql.getIsSuperuser());
            database.getUserProperties().put("superuser", query.fieldByName("usesuper").getString());
            database.getUserProperties().put("version", PostgreSQLDbInfoProvider.instance.getVersion(database));
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
    }

    public void beforeDisconnect(Database database) {
    }

    public String getDescription() {
        return this.stringManager.getString("PostgreSQLDatabaseProvider-description");
    }

    public String getGroupName() {
        return "PostgreSQL";
    }
}

