/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.postgresql.services;

import java.awt.EventQueue;
import javax.swing.JMenu;
import javax.swing.JToolBar;
import pl.mpak.orbada.plugins.providers.PerspectiveProvider;
import pl.mpak.orbada.plugins.queue.PluginMessage;
import pl.mpak.orbada.postgresql.OrbadaPostgreSQLPlugin;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class PostgreSQLPerspectiveProvider
extends PerspectiveProvider {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaPostgreSQLPlugin.class);

    public boolean isForDatabase(Database database) {
        if (database == null) {
            return false;
        }
        return "PostgreSQL".equals(database.getDriverType());
    }

    public String getDescription() {
        return this.stringManager.getString("PostgreSQLPerspectiveProvider-description");
    }

    public String getGroupName() {
        return "PostgreSQL";
    }

    public void initialize() {
        JMenu postgresql = new JMenu("PostgreSQL");
        JToolBar toolBar = new JToolBar("PostgreSQL");
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
        this.accesibilities.addToolBar(toolBar);
    }

    public void processMessage(PluginMessage message) {
        if (this.getAccesibilities() != null && this.getAccesibilities().getDatabase() != null && this.getAccesibilities().getDatabase().getUniqueID().equals(message.getDestinationId()) && message.isMessageId("freeze-object")) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                }
            });
            message.setServed(true);
        }
    }
}

