/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.postgresql.services.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.plugins.providers.ComponentActionProvider;
import pl.mpak.orbada.postgresql.OrbadaPostgreSQLPlugin;
import pl.mpak.orbada.postgresql.gui.admin.SessionsPanelView;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class PostgreSQLCancelQueryAction
extends ComponentActionProvider {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaPostgreSQLPlugin.class);

    private ActionListener createActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewTable vt;
                if (PostgreSQLCancelQueryAction.this.getComponent() instanceof ViewTable && (vt = (ViewTable)PostgreSQLCancelQueryAction.this.getComponent()).getSelectedRow() >= 0) {
                    try {
                        SessionsPanelView spv = (SessionsPanelView)((Object)SwingUtil.getOwnerComponent(SessionsPanelView.class, (Component)PostgreSQLCancelQueryAction.this.getComponent()));
                        vt.getQuery().getRecord(vt.getSelectedRow());
                        String session = vt.getQuery().fieldByName("pid").getString();
                        int result = MessageBox.show((Component)((Object)spv), (String)PostgreSQLCancelQueryAction.this.stringManager.getString("command"), (String)PostgreSQLCancelQueryAction.this.stringManager.getString("cancel-query-selected-session-q", (Object)session), (int[])ModalResult.YESNO, (int)3);
                        if (result == 5) {
                            PostgreSQLCancelQueryAction.this.getDatabase().executeCommand("select pg_cancel_backend(" + session + ")");
                            if (spv != null) {
                                spv.refresh();
                            } else {
                                vt.getQuery().refresh();
                            }
                        }
                    }
                    catch (Exception ex) {
                        MessageBox.show((String)PostgreSQLCancelQueryAction.this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
                    }
                }
            }
        };
    }

    public boolean isForComponent(Database database, String actionType) {
        if (database == null || !"PostgreSQL".equals(database.getDriverType())) {
            return false;
        }
        if (!"postgresql-sessions-actions".equals(actionType)) {
            return false;
        }
        this.setText(this.getDescription());
        this.setTooltip(this.stringManager.getString("PostgreSQLCancelQueryAction-hint"));
        this.setSmallIcon(ImageManager.getImage((String)"/pl/mpak/res/icons/stop-query.gif"));
        this.setActionCommandKey("PostgreSQLCancelQueryAction");
        this.addActionListener(this.createActionListener());
        return true;
    }

    public String getDescription() {
        return this.stringManager.getString("PostgreSQLCancelQueryAction-description");
    }

    public String getGroupName() {
        return "PostgreSQL";
    }

    public boolean isToolButton() {
        return true;
    }
}

