/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.postgresql.services.actions;

import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.EventObject;
import pl.mpak.orbada.postgresql.OrbadaPostgreSQLPlugin;
import pl.mpak.orbada.universal.providers.UniversalActionProvider;
import pl.mpak.usedb.core.Command;
import pl.mpak.usedb.core.CommandListener;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.TaskUtil;

public class PostgreSQLSQLWarningsService
extends UniversalActionProvider {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaPostgreSQLPlugin.class);

    public boolean isForDatabase(Database database) {
        if (database == null) {
            return false;
        }
        return "PostgreSQL".equals(database.getDriverType());
    }

    public boolean addToolButton() {
        return false;
    }

    public boolean addMenuItem() {
        return false;
    }

    public boolean addToEditor() {
        return false;
    }

    public String getDescription() {
        return this.stringManager.getString("PostgreSQLSQLWarningsService-description");
    }

    public String getGroupName() {
        return "PostgreSQL";
    }

    private void statementWarnings(Statement stmt) throws SQLException {
        boolean found = false;
        if (stmt != null) {
            for (SQLWarning warn = stmt.getWarnings(); warn != null; warn = warn.getNextWarning()) {
                this.scriptResultPanel.append(warn.toString() + "\n");
                found = true;
            }
            if (found) {
                stmt.clearWarnings();
            }
        }
    }

    public void beforeOpenQuery(final Query query) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    int waitCount = 10;
                    while (query.getState() != Query.State.OPENING || query.getStatement() == null) {
                        TaskUtil.sleep((long)100L);
                        if (--waitCount == 0) {
                            return;
                        }
                        if (Thread.currentThread().getState() != Thread.State.TERMINATED) continue;
                    }
                    while (query.getState() == Query.State.OPENING) {
                        PostgreSQLSQLWarningsService.this.statementWarnings(query.getStatement());
                        if (Thread.currentThread().getState() != Thread.State.TERMINATED) {
                            TaskUtil.sleep((long)1000L);
                            continue;
                        }
                        break;
                    }
                }
                catch (SQLException ex) {
                    ExceptionUtil.processException((Throwable)ex);
                }
            }
        }).start();
    }

    public void beforeExecuteCommand(final Command command) {
        command.addCommandListener(new CommandListener(){

            public void beforeExecute(EventObject e) {
            }

            public void afterExecute(EventObject e) {
                if (((Command)e.getSource()).getStatement() != null) {
                    try {
                        PostgreSQLSQLWarningsService.this.statementWarnings(((Command)e.getSource()).getStatement());
                    }
                    catch (SQLException ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                }
            }

            public void errorPerformed(EventObject e) {
            }
        });
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    int waitCount = 10;
                    while (command.getState() != Command.State.EXECUTEING || command.getStatement() == null) {
                        TaskUtil.sleep((long)100L);
                        if (--waitCount == 0) {
                            return;
                        }
                        if (Thread.currentThread().getState() != Thread.State.TERMINATED) continue;
                    }
                    while (command.getState() == Command.State.EXECUTEING) {
                        PostgreSQLSQLWarningsService.this.statementWarnings(command.getStatement());
                        if (Thread.currentThread().getState() != Thread.State.TERMINATED) {
                            TaskUtil.sleep((long)1000L);
                            continue;
                        }
                        break;
                    }
                }
                catch (SQLException ex) {
                    ExceptionUtil.processException((Throwable)ex);
                }
            }
        }).start();
    }

    public void afterOpenQuery(Query query) {
        if (query.getStatement() != null) {
            try {
                this.statementWarnings(query.getStatement());
            }
            catch (SQLException ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }
}

