/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.postgresql.services.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.plugins.providers.ComponentActionProvider;
import pl.mpak.orbada.postgresql.OrbadaPostgreSQLPlugin;
import pl.mpak.orbada.postgresql.gui.admin.SessionsPanelView;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class PostgreSQLTerminateSessionAction
extends ComponentActionProvider {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaPostgreSQLPlugin.class);

    private ActionListener createActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewTable vt;
                if (PostgreSQLTerminateSessionAction.this.getComponent() instanceof ViewTable && (vt = (ViewTable)PostgreSQLTerminateSessionAction.this.getComponent()).getSelectedRow() >= 0) {
                    try {
                        SessionsPanelView spv = (SessionsPanelView)((Object)SwingUtil.getOwnerComponent(SessionsPanelView.class, (Component)PostgreSQLTerminateSessionAction.this.getComponent()));
                        vt.getQuery().getRecord(vt.getSelectedRow());
                        String session = vt.getQuery().fieldByName("pid").getString();
                        int result = MessageBox.show((Component)((Object)spv), (String)PostgreSQLTerminateSessionAction.this.stringManager.getString("session"), (String)PostgreSQLTerminateSessionAction.this.stringManager.getString("terminate-selected-session-q", (Object)session), (int[])ModalResult.YESNO, (int)3);
                        if (result == 5) {
                            PostgreSQLTerminateSessionAction.this.getDatabase().executeCommand("select pg_terminate_backend(" + session + ")");
                            if (spv != null) {
                                spv.refresh();
                            } else {
                                vt.getQuery().refresh();
                            }
                        }
                    }
                    catch (Exception ex) {
                        MessageBox.show((String)PostgreSQLTerminateSessionAction.this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
                    }
                }
            }
        };
    }

    public boolean isForComponent(Database database, String actionType) {
        if (database == null || !"PostgreSQL".equals(database.getDriverType())) {
            return false;
        }
        if (!"postgresql-sessions-actions".equals(actionType) && !"postgresql-session-locks-actions".equals(actionType)) {
            return false;
        }
        this.setText(this.getDescription());
        this.setTooltip(this.stringManager.getString("PostgreSQLTerminateSessionAction-hint"));
        this.setSmallIcon(ImageManager.getImage((String)"/pl/mpak/res/icons/stop16.gif"));
        this.setActionCommandKey("PostgreSQLTerminateSessionAction");
        this.addActionListener(this.createActionListener());
        return true;
    }

    public String getDescription() {
        return this.stringManager.getString("PostgreSQLTerminateSessionAction-description");
    }

    public String getGroupName() {
        return "PostgreSQL";
    }

    public boolean isToolButton() {
        return true;
    }
}

