/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.postgresql.util;

import java.awt.EventQueue;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.gui.comps.AbsOrbadaSyntaxTextArea;
import pl.mpak.orbada.plugins.PleaseWait;
import pl.mpak.orbada.postgresql.OrbadaPostgreSQLPlugin;
import pl.mpak.orbada.postgresql.Sql;
import pl.mpak.orbada.postgresql.services.PostgreSQLDbInfoProvider;
import pl.mpak.sky.gui.swing.syntax.SyntaxTextArea;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class SourceCreator {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaPostgreSQLPlugin.class);
    private Database database;
    private SyntaxTextArea textArea;

    public SourceCreator(Database database) {
        this.database = database;
    }

    public SourceCreator(Database database, SyntaxTextArea textArea) {
        this(database);
        this.textArea = textArea;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSource(final String schemaName, final String objectType, final String objectName, String onObjectName) {
        String source;
        PleaseWait wait;
        if (this.textArea != null) {
            wait = PleaseWait.createSqlWait();
            Application.get().startPleaseWait(wait);
        } else {
            wait = null;
        }
        try {
            source = !StringUtil.equals((String)objectName, (String)"") ? ("TRIGGER".equalsIgnoreCase(objectType) ? this.getTrigger(schemaName, objectName, onObjectName) : ("RULE".equalsIgnoreCase(objectType) ? this.getRule(schemaName, objectName, onObjectName) : ("FUNCTION".equalsIgnoreCase(objectType) || "TRIGGER FUNCTION".equalsIgnoreCase(objectType) ? this.getFunction(schemaName, objectName) : ("VIEW".equalsIgnoreCase(objectType) ? this.getView(schemaName, objectName) : ("TYPE".equalsIgnoreCase(objectType) ? this.getType(schemaName, objectName) : ("AGGREGATE".equalsIgnoreCase(objectType) ? this.getAggregate(schemaName, objectName) : "")))))) : "";
        }
        finally {
            if (wait != null) {
                Application.get().stopPleaseWait(wait);
            }
        }
        if (this.textArea != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SourceCreator.this.textArea instanceof AbsOrbadaSyntaxTextArea) {
                        ((AbsOrbadaSyntaxTextArea)SourceCreator.this.textArea).setDatabaseObject(schemaName, objectType, objectName, source);
                    }
                    SourceCreator.this.textArea.getEditorArea().setCaretPosition(0);
                }
            });
        }
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTrigger(String schemaName, String objectName, String onObjectName) {
        Query query = this.database.createQuery();
        try {
            query.setSqlText(Sql.getTriggerSource());
            query.paramByName("SCHEMA_NAME").setString(schemaName);
            query.paramByName("OBJECT_NAME").setString(onObjectName);
            query.paramByName("TRIGGER_NAME").setString(objectName);
            query.open();
            if (!query.eof()) {
                String string = "DROP TRIGGER " + query.fieldByName("trigger_name").getString() + " ON " + query.fieldByName("object_name").getString() + "\n/\n" + StringUtil.breakBefore((String)query.fieldByName("source").getString(), (String[])new String[]{" AFTER ", " BEFORE ", " INSTED ", " ON ", " EXECUTE "}, (String)"\n ") + "\n/\n" + "COMMENT ON TRIGGER " + query.fieldByName("trigger_name").getString() + " ON " + query.fieldByName("object_name").getString() + " IS " + query.fieldByName("description").getString() + "\n/";
                return string;
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFunction(String schemaName, String objectName) {
        Query query = this.database.createQuery();
        try {
            String grants = "";
            query.setSqlText(Sql.getFunctionPrivilegeCommandList(null));
            query.paramByName("SCHEMA_NAME").setString(schemaName);
            query.paramByName("OBJECT_NAME").setString(objectName);
            query.open();
            while (!query.eof()) {
                grants = grants + query.fieldByName("command").getString() + "\n/\n";
                query.next();
            }
            query.setSqlText(Sql.getFunctionSource());
            query.paramByName("SCHEMA_NAME").setString(schemaName);
            query.paramByName("FUNCTION_NAME").setString(objectName);
            query.open();
            if (!query.eof()) {
                String string = "--DROP FUNCTION " + query.fieldByName("function_prot").getString() + "\n--/\n" + query.fieldByName("source").getString() + "/\n" + "ALTER FUNCTION " + query.fieldByName("function_prot").getString() + " OWNER TO " + query.fieldByName("owner_name").getString() + "\n/\n" + grants + "COMMENT ON FUNCTION " + query.fieldByName("function_prot").getString() + " IS " + query.fieldByName("description").getString() + "\n/";
                return string;
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRule(String schemaName, String objectName, String onObjectName) {
        Query query = this.database.createQuery();
        try {
            query.setSqlText(Sql.getRuleSource());
            query.paramByName("SCHEMA_NAME").setString(schemaName);
            query.paramByName("OBJECT_NAME").setString(onObjectName);
            query.paramByName("RULE_NAME").setString(objectName);
            query.open();
            if (!query.eof()) {
                String string = "DROP RULE " + query.fieldByName("rule_name").getString() + " ON " + query.fieldByName("object_name").getString() + "\n/\n" + query.fieldByName("source").getString() + "\n/\n" + "COMMENT ON RULE " + query.fieldByName("rule_name").getString() + " ON " + query.fieldByName("object_name").getString() + " IS " + query.fieldByName("description").getString() + "\n/";
                return string;
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getView(String schemaName, String objectName) {
        Query query = this.database.createQuery();
        try {
            String grants = "";
            query.setSqlText(Sql.getPrivilegeCommandList(null));
            query.paramByName("SCHEMA_NAME").setString(schemaName);
            query.paramByName("OBJECT_NAME").setString(objectName);
            query.open();
            while (!query.eof()) {
                grants = grants + query.fieldByName("command").getString() + "\n/\n";
                query.next();
            }
            query.setSqlText(Sql.getViewSource());
            query.paramByName("SCHEMA_NAME").setString(schemaName);
            query.paramByName("VIEW_NAME").setString(objectName);
            query.open();
            if (!query.eof()) {
                String string = "--DROP VIEW " + query.fieldByName("view_name").getString() + "\n--/\n" + "---- !!! " + stringManager.getString("SourceCreator-extra-alter-view") + "\n" + "--delete from pg_attribute where attrelid = '" + query.fieldByName("view_name").getString() + "'::regclass\n--/\n" + "--update pg_class set relnatts = 0 where oid = '" + query.fieldByName("view_name").getString() + "'::regclass\n--/\n" + "CREATE OR REPLACE VIEW " + query.fieldByName("view_name").getString() + " AS\n" + query.fieldByName("source").getString() + "\n/\n" + "ALTER VIEW " + query.fieldByName("view_name").getString() + " OWNER TO " + query.fieldByName("owner_name").getString() + "\n/\n" + grants + "COMMENT ON VIEW " + query.fieldByName("view_name").getString() + " IS " + query.fieldByName("description").getString() + "\n/";
                return string;
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getType(String schemaName, String objectName) {
        Query query = this.database.createQuery();
        try {
            query.setSqlText(Sql.getTypeSource(PostgreSQLDbInfoProvider.instance.getVersion(this.database)));
            query.paramByName("SCHEMA_NAME").setString(schemaName);
            query.paramByName("TYPE_NAME").setString(objectName);
            query.open();
            if (!query.eof()) {
                String string = query.fieldByName("source").getString();
                return string;
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAggregate(String schemaName, String objectName) {
        Query query = this.database.createQuery();
        try {
            query.setSqlText(Sql.getAggregateSource());
            query.paramByName("SCHEMA_NAME").setString(schemaName);
            query.paramByName("AGGREGATE_NAME").setString(objectName);
            query.open();
            if (!query.eof()) {
                String string = query.fieldByName("source").getString();
                return string;
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
        return "";
    }
}

