/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.snippets;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;
import pl.mpak.orbada.gui.comps.OrbadaJavaSyntaxTextArea;
import pl.mpak.orbada.gui.comps.OrbadaSyntaxTextArea;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.snippets.OrbadaSnippetsPlugin;
import pl.mpak.sky.gui.swing.syntax.ApplySyntaxTextAreaEvent;
import pl.mpak.sky.gui.swing.syntax.Snippet;
import pl.mpak.sky.gui.swing.syntax.SyntaxTextArea;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringUtil;

public class SnippetsManager {
    private IApplication application;
    private ArrayList<SnippetFor> snippetList;
    private ISettings settings;
    private boolean inited = false;
    public static final String SET_SNIPPETS_ENABLED = "snippets-enabled";

    public SnippetsManager(IApplication application) {
        this.application = application;
        this.settings = application.getSettings("orbada-snippets-plugin");
        this.snippetList = new ArrayList();
    }

    public void reloadSnippets(boolean reset, boolean refreshEditors) {
        if (reset || !this.inited) {
            this.inited = true;
            this.snippetList.clear();
            try {
                Query query = this.application.getOrbadaDatabase().createQuery();
                query.setSqlText("select snp_name, snp_code, snp_editor, snp_immediate, case when dtp_id is null then 'all' else dtp_name end driver_type \n  from snippets left join driver_types on snp_dtp_id = dtp_id\n where snp_active = 'T'\n   and (snp_usr_id is null or snp_usr_id = :USR_ID)");
                query.paramByName("USR_ID").setString(this.application.getUserId());
                query.open();
                while (!query.eof()) {
                    SnippetFor sf = new SnippetFor();
                    sf.editor = query.fieldByName("snp_editor").getString();
                    sf.driverType = query.fieldByName("driver_type").getString();
                    sf.snippet = new Snippet(query.fieldByName("snp_name").getString(), query.fieldByName("snp_code").getString(), StringUtil.toBoolean((String)query.fieldByName("snp_immediate").getString()));
                    this.snippetList.add(sf);
                    query.next();
                }
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
        if (refreshEditors) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SyntaxTextArea.apply((ApplySyntaxTextAreaEvent)new ApplySyntaxTextAreaEvent(){

                        public void apply(SyntaxTextArea editor) {
                            OrbadaSnippetsPlugin.getSnippetsManager().refreshSnippets(editor);
                        }
                    });
                }
            });
        }
    }

    private List<Snippet> getSnippets(String editor, String driverType) {
        ArrayList<Snippet> snippets = new ArrayList<Snippet>();
        for (SnippetFor snippet : this.snippetList) {
            if (!StringUtil.equalsIgnoreCase((String)snippet.editor, (String)editor) || !StringUtil.equalAnyOfString((String)snippet.driverType, (String[])new String[]{driverType, "all"}, (boolean)true)) continue;
            snippets.add(snippet.snippet);
        }
        return snippets;
    }

    public void refreshSnippets(SyntaxTextArea syntaxTextArea) {
        this.reloadSnippets(false, false);
        syntaxTextArea.getDocument().clearSnippets();
        if (this.settings.getValue(SET_SNIPPETS_ENABLED, Boolean.valueOf(true)).booleanValue() && syntaxTextArea != null) {
            OrbadaSyntaxTextArea area;
            List<Snippet> snippets = null;
            if (syntaxTextArea instanceof OrbadaSyntaxTextArea) {
                area = (OrbadaSyntaxTextArea)syntaxTextArea;
                if (area.getDatabase() != null) {
                    snippets = this.getSnippets("sql", area.getDatabase().getDriverType());
                }
            } else if (syntaxTextArea instanceof OrbadaJavaSyntaxTextArea && (area = (OrbadaJavaSyntaxTextArea)syntaxTextArea).getDatabase() != null) {
                snippets = this.getSnippets("java", area.getDatabase().getDriverType());
            }
            if (snippets != null) {
                for (Snippet snippet : snippets) {
                    syntaxTextArea.getDocument().addSnippet(snippet);
                }
            }
        }
    }

    private class SnippetFor {
        public String editor;
        public String driverType;
        public Snippet snippet;

        private SnippetFor() {
        }
    }
}

