/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.snippets.db;

import pl.mpak.sky.gui.swing.syntax.Snippet;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.br.DefaultBufferedRecord;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringUtil;
import pl.mpak.util.id.UniqueID;
import pl.mpak.util.variant.Variant;

public class SnippetRecord
extends DefaultBufferedRecord {
    public SnippetRecord(Database database) {
        super(database, "SNIPPETS", "SNP_ID");
        this.add("SNP_ID", new Variant(new UniqueID().toString()), 11, false);
        this.add("SNP_USR_ID", 11, true);
        this.add("SNP_DTP_ID", 11, true);
        this.add("SNP_NAME", 11, true);
        this.add("SNP_CODE", 11, true);
        this.add("SNP_EDITOR", new Variant("sql"), 11, true);
        this.add("SNP_ACTIVE", new Variant("T"), 11, true);
        this.add("SNP_IMMEDIATE", 11, true);
    }

    public SnippetRecord(Database database, String snp_id) throws UseDBException {
        this(database);
        this.loadRecord(new Variant(snp_id));
    }

    public SnippetRecord(Database database, String name, String code, String editor, boolean immediate) {
        this(database);
        this.fieldByName("SNP_NAME").setString(name);
        this.fieldByName("SNP_CODE").setString(code);
        this.fieldByName("SNP_EDITOR").setString(editor);
        this.fieldByName("SNP_IMMEDIATE").setString(immediate ? "T" : "F");
    }

    public SnippetRecord(Database database, String id, String name, String code, String editor, boolean immediate) {
        this(database, name, code, editor, immediate);
        this.fieldByName("SNP_ID").setString(id);
    }

    public Snippet getSnippet() {
        return new Snippet(this.getName(), this.getCode(), this.getImmediate());
    }

    public String getId() {
        return this.fieldByName("SNP_ID").getValue().toString();
    }

    public void setId(String id) {
        this.fieldByName("SNP_ID").setString(id);
    }

    public String getUsrId() {
        if (this.fieldByName("SNP_USR_ID").isNull()) {
            return null;
        }
        return this.fieldByName("SNP_USR_ID").getValue().toString();
    }

    public void setUsrId(String usrId) {
        this.fieldByName("SNP_USR_ID").setString(usrId);
    }

    public String getDtpId() {
        if (this.fieldByName("SNP_DTP_ID").isNull()) {
            return null;
        }
        return this.fieldByName("SNP_DTP_ID").getValue().toString();
    }

    public void setDtpId(String drvId) {
        this.fieldByName("SNP_DTP_ID").setString(drvId);
    }

    public String getName() {
        return this.fieldByName("SNP_NAME").getValue().toString();
    }

    public void setName(String name) {
        this.fieldByName("SNP_NAME").setString(name);
    }

    public String getCode() {
        return this.fieldByName("SNP_CODE").getValue().toString();
    }

    public void setCode(String code) {
        this.fieldByName("SNP_CODE").setString(code);
    }

    public String getEditor() {
        return this.fieldByName("SNP_EDITOR").getValue().toString();
    }

    public void setEditor(String editor) {
        this.fieldByName("SNP_EDITOR").setString(editor);
    }

    public boolean getActive() {
        return StringUtil.toBoolean((String)this.fieldByName("SNP_ACTIVE").getValue().toString());
    }

    public void setActive(boolean active) {
        this.fieldByName("SNP_ACTIVE").setString(active ? "T" : "F");
    }

    public boolean getImmediate() {
        return StringUtil.toBoolean((String)this.fieldByName("SNP_IMMEDIATE").getValue().toString());
    }

    public void setImmediate(boolean immediate) {
        this.fieldByName("SNP_IMMEDIATE").setString(immediate ? "T" : "F");
    }
}

