/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.snippets.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IntrospectionException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.gui.comps.OrbadaSyntaxTextArea;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.snippets.OrbadaSnippetsPlugin;
import pl.mpak.orbada.snippets.db.SnippetRecord;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ComboBox;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.br.BufferedRecord;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.FieldLinkType;
import pl.mpak.usedb.gui.RecordLink;
import pl.mpak.usedb.gui.linkreq.FieldRequeiredNotNull;
import pl.mpak.usedb.gui.linkreq.IFieldRequires;
import pl.mpak.usedb.gui.swing.QueryComboBox;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class SnippetEditDialog
extends JDialog {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaSnippetsPlugin.class);
    private IApplication application;
    private int modalResult = 0;
    private SnippetRecord snippet;
    private RecordLink dataLink;
    private String snp_id;
    private JButton buttonCancel;
    private JButton buttonOk;
    private JCheckBox checkActive;
    private JCheckBox checkAllUsers;
    private JCheckBox checkImmediate;
    private Action cmCancel;
    private Action cmOk;
    private QueryComboBox comboDriverType;
    private ComboBox comboEditor;
    private OrbadaSyntaxTextArea editCode;
    private TextField editName;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel7;
    private Query queryDriverTypes;

    public SnippetEditDialog(IApplication application, String snp_id, SnippetRecord snippet) throws IntrospectionException, UseDBException {
        super(SwingUtil.getRootFrame());
        this.application = application;
        this.snp_id = snp_id;
        this.snippet = snippet;
        this.initComponents();
        this.init();
    }

    public static String show(IApplication application, String snp_id) throws IntrospectionException, UseDBException {
        SnippetEditDialog dialog = new SnippetEditDialog(application, snp_id, null);
        dialog.setVisible(true);
        return dialog.modalResult == 1 ? dialog.snp_id : null;
    }

    public static String show(IApplication application, String snp_id, SnippetRecord snippet) throws IntrospectionException, UseDBException {
        SnippetEditDialog dialog = new SnippetEditDialog(application, snp_id, snippet);
        dialog.setVisible(true);
        return dialog.modalResult == 1 ? dialog.snp_id : null;
    }

    private void init() throws IntrospectionException, UseDBException {
        try {
            this.queryDriverTypes.open();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        this.dataLink = new RecordLink();
        this.dataLink.add("SNP_NAME", (Component)this.editName, (IFieldRequires)new FieldRequeiredNotNull(this.stringManager.getString("snippet-name")));
        this.dataLink.add("SNP_EDITOR", (Component)this.comboEditor, "selectedItem");
        this.dataLink.add("SNP_DTP_ID", (Component)this.comboDriverType, "selectedItem");
        this.dataLink.add("SNP_ACTIVE", (Component)this.checkActive, "selected", FieldLinkType.Boolean_TF);
        this.dataLink.add("SNP_IMMEDIATE", (Component)this.checkImmediate, "selected", FieldLinkType.Boolean_TF);
        this.dataLink.add("SNP_CODE", (Component)this.editCode, (IFieldRequires)new FieldRequeiredNotNull(this.stringManager.getString("snippet-code")));
        if (this.snippet == null) {
            this.snippet = this.snp_id != null ? new SnippetRecord(this.application.getOrbadaDatabase(), this.snp_id) : new SnippetRecord(this.application.getOrbadaDatabase());
        }
        this.dataLink.updateComponents((BufferedRecord)this.snippet);
        this.checkAllUsers.setSelected(this.snippet.getUsrId() == null);
        if (!this.application.isUserAdmin()) {
            this.checkAllUsers.setEnabled(false);
            this.checkAllUsers.setSelected(true);
        }
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        SwingUtil.centerWithinScreen((Window)this);
    }

    @Override
    public void dispose() {
        this.queryDriverTypes.close();
        super.dispose();
    }

    private void initComponents() {
        this.cmOk = new Action();
        this.cmCancel = new Action();
        this.queryDriverTypes = new Query();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.jLabel1 = new JLabel();
        this.editName = new TextField();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.editCode = new OrbadaSyntaxTextArea();
        this.checkAllUsers = new JCheckBox();
        this.jLabel7 = new JLabel();
        this.comboDriverType = new QueryComboBox();
        this.comboEditor = new ComboBox();
        this.checkActive = new JCheckBox();
        this.checkImmediate = new JCheckBox();
        this.cmOk.setActionCommandKey("cmOk");
        this.cmOk.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmOk.setText(this.stringManager.getString("cmOk-text"));
        this.cmOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SnippetEditDialog.this.cmOkActionPerformed(evt);
            }
        });
        this.cmCancel.setActionCommandKey("cmCancel");
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(this.stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SnippetEditDialog.this.cmCancelActionPerformed(evt);
            }
        });
        this.queryDriverTypes.setDatabase(this.application.getOrbadaDatabase());
        try {
            this.queryDriverTypes.setSqlText("select dtp_id, dtp_name from driver_types\nunion all select null, 'Any/All' from driver_types where dtp_id = (select min(dtp_id) from driver_types)\norder by dtp_name");
        }
        catch (UseDBException e1) {
            e1.printStackTrace();
        }
        this.setDefaultCloseOperation(2);
        this.setTitle(this.stringManager.getString("SnippetEditDialog-title"));
        this.setModal(true);
        this.buttonOk.setAction((javax.swing.Action)this.cmOk);
        this.buttonOk.setMargin(new Insets(2, 2, 2, 2));
        this.buttonOk.setPreferredSize(new Dimension(85, 25));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setMargin(new Insets(2, 2, 2, 2));
        this.buttonCancel.setPreferredSize(new Dimension(85, 25));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText(this.stringManager.getString("snippet-name-dd"));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("snippet-editor-dd"));
        this.jLabel3.setText(this.stringManager.getString("code-information"));
        this.checkAllUsers.setText(this.stringManager.getString("for-all-users"));
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText(this.stringManager.getString("for-driver-dd"));
        this.comboDriverType.setDisplayField("DTP_NAME");
        this.comboDriverType.setKeyField("DTP_ID");
        this.comboDriverType.setQuery(this.queryDriverTypes);
        this.comboEditor.setModel(new DefaultComboBoxModel<String>(new String[]{"sql", "java"}));
        this.checkActive.setText(this.stringManager.getString("snippet-active"));
        this.checkImmediate.setText(this.stringManager.getString("snippet-immediate-info"));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.editCode, GroupLayout.Alignment.LEADING, -1, 513, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.checkAllUsers).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 254, Short.MAX_VALUE).addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel1, -2, 131, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.editName, -1, 378, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel2, -2, 131, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.comboEditor, -2, 114, -2)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel7, -2, 131, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkActive).addComponent((Component)this.comboDriverType, -1, 378, Short.MAX_VALUE).addComponent(this.checkImmediate))).addComponent(this.jLabel3, -1, 513, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent((Component)this.editName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent((Component)this.comboEditor, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent((Component)this.comboDriverType, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.checkActive).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.checkImmediate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.editCode, -1, 112, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonOk, -2, -1, -2).addComponent(this.checkAllUsers)).addContainerGap()));
        this.pack();
    }

    private void cmOkActionPerformed(ActionEvent evt) {
        try {
            this.dataLink.updateRecord((BufferedRecord)this.snippet);
            if (this.checkAllUsers.isSelected()) {
                this.snippet.setUsrId(null);
            } else {
                this.snippet.setUsrId(this.application.getUserId());
            }
            if (this.snippet.isChanged()) {
                if (this.snp_id == null) {
                    this.snippet.applyInsert();
                    this.snp_id = this.snippet.getId();
                } else {
                    this.snippet.applyUpdate();
                }
            }
            this.modalResult = 1;
            this.dispose();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int[])new int[]{1});
        }
    }

    private void cmCancelActionPerformed(ActionEvent evt) {
        this.modalResult = 2;
        this.dispose();
    }
}

