/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.snippets.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.EventObject;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.ISettingsComponent;
import pl.mpak.orbada.snippets.OrbadaSnippetsPlugin;
import pl.mpak.orbada.snippets.db.SnippetRecord;
import pl.mpak.orbada.snippets.gui.SnippetEditDialog;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.DefaultQueryListener;
import pl.mpak.usedb.core.QueryListener;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableCellRendererFilter;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.crf.YesNoCellRendererFilter;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.FileUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.files.FileExtensionFilter;
import pl.mpak.util.id.UniqueID;
import pl.mpak.util.variant.Variant;

public class SnippetsSettingsPanel
extends JPanel
implements ISettingsComponent,
Closeable {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaSnippetsPlugin.class);
    private IApplication application;
    private ISettings settings;
    private boolean changed;
    private JButton buttonDelete;
    private JButton buttonEdit;
    private JButton buttonExport;
    private JButton buttonImport;
    private JButton buttonNew;
    private JCheckBox checkSnippetsEnabled;
    private Action cmDelete;
    private Action cmEdit;
    private Action cmExport;
    private Action cmImport;
    private Action cmNew;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private ViewTable tableSnippets;

    public SnippetsSettingsPanel(IApplication application) {
        this.application = application;
        this.changed = false;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.settings = this.application.getSettings("orbada-snippets-plugin");
        SwingUtil.setButtonSizesTheSame((AbstractButton[])new AbstractButton[]{this.buttonNew, this.buttonEdit, this.buttonDelete, this.buttonExport, this.buttonImport});
        this.tableSnippets.getQuery().setDatabase(this.application.getOrbadaDatabase());
        this.tableSnippets.getQuery().addQueryListener((QueryListener)new DefaultQueryListener(){

            public void afterOpen(EventObject e) {
                SnippetsSettingsPanel.this.updateActions();
            }

            public void afterClose(EventObject e) {
                SnippetsSettingsPanel.this.updateActions();
            }
        });
        this.tableSnippets.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SnippetsSettingsPanel.this.tableSnippets.getSelectedRow() >= 0) {
                    try {
                        SnippetsSettingsPanel.this.tableSnippets.getQuery().getRecord(SnippetsSettingsPanel.this.tableSnippets.getSelectedRow());
                        SnippetsSettingsPanel.this.updateActions();
                    }
                    catch (Exception ex) {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                } else {
                    SnippetsSettingsPanel.this.cmEdit.setEnabled(false);
                    SnippetsSettingsPanel.this.cmDelete.setEnabled(false);
                }
            }
        });
        this.tableSnippets.addColumn((TableColumn)new QueryTableColumn("scope", this.stringManager.getString("scope"), 70));
        this.tableSnippets.addColumn((TableColumn)new QueryTableColumn("snp_name", this.stringManager.getString("snippet-name"), 150));
        this.tableSnippets.addColumn((TableColumn)new QueryTableColumn("snp_editor", this.stringManager.getString("snippet-editor"), 50));
        this.tableSnippets.addColumn((TableColumn)new QueryTableColumn("snp_active", this.stringManager.getString("snippet-active"), 30, (TableCellRenderer)new QueryTableCellRenderer((QueryTableCellRendererFilter)new YesNoCellRendererFilter())));
        this.tableSnippets.addColumn((TableColumn)new QueryTableColumn("snp_immediate", this.stringManager.getString("snippet-immediate"), 30, (TableCellRenderer)new QueryTableCellRenderer((QueryTableCellRendererFilter)new YesNoCellRendererFilter(SwingUtil.Color.GREEN, this.tableSnippets.getForeground()))));
        this.tableSnippets.addColumn((TableColumn)new QueryTableColumn("driver_type", this.stringManager.getString("driver-type"), 100));
        this.restoreSettings();
        this.refresh(null);
    }

    private void updateActions() {
        block5: {
            if (this.tableSnippets.getQuery().isActive() && this.tableSnippets.getSelectedRow() >= 0) {
                try {
                    if (this.tableSnippets.getQuery().fieldByName("snp_usr_id").isNull()) {
                        this.cmEdit.setEnabled(this.application.isUserAdmin());
                        this.cmDelete.setEnabled(this.application.isUserAdmin());
                        break block5;
                    }
                    this.cmEdit.setEnabled(true);
                    this.cmDelete.setEnabled(true);
                }
                catch (Exception ex) {
                    this.cmEdit.setEnabled(false);
                    this.cmDelete.setEnabled(false);
                }
            } else {
                this.cmEdit.setEnabled(false);
                this.cmDelete.setEnabled(false);
            }
        }
        this.cmNew.setEnabled(this.tableSnippets.getQuery().isActive());
    }

    private void refresh(String snp_id) {
        try {
            if (snp_id == null && this.tableSnippets.getQuery().isActive() && this.tableSnippets.getSelectedRow() >= 0) {
                this.tableSnippets.getQuery().getRecord(this.tableSnippets.getSelectedRow());
                snp_id = this.tableSnippets.getQuery().fieldByName("snp_id").getString();
            }
            this.tableSnippets.getQuery().close();
            this.tableSnippets.getQuery().setSqlText("select snp_id, snp_usr_id, snp_name, snp_editor, snp_active, snp_immediate, case when snp_usr_id is null then 'Global' else 'User' end scope, dtp_name driver_type \n  from snippets left join driver_types on snp_dtp_id = dtp_id\n where (snp_usr_id is null or snp_usr_id = :USR_ID)\n order by snp_name");
            this.tableSnippets.getQuery().paramByName("usr_id").setString(this.application.getUserId());
            this.tableSnippets.getQuery().open();
            if (snp_id != null && this.tableSnippets.getQuery().locate("snp_id", new Variant(snp_id))) {
                this.tableSnippets.changeSelection(this.tableSnippets.getQuery().getCurrentRecord().getIndex(), 0, false, false);
            } else {
                this.tableSnippets.changeSelection(0, 0, false, false);
            }
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
    }

    public void restoreSettings() {
        this.checkSnippetsEnabled.setSelected(this.settings.getValue("snippets-enabled", Boolean.TRUE));
    }

    public void applySettings() {
        if (this.checkSnippetsEnabled.isSelected() != this.settings.getValue("snippets-enabled", Boolean.TRUE).booleanValue() || this.changed) {
            this.settings.setValue("snippets-enabled", Boolean.valueOf(this.checkSnippetsEnabled.isSelected()));
            this.settings.store();
            OrbadaSnippetsPlugin.getSnippetsManager().reloadSnippets(true, true);
        }
    }

    public void cancelSettings() {
        this.restoreSettings();
    }

    @Override
    public void close() throws IOException {
        this.tableSnippets.getQuery().close();
    }

    private void initComponents() {
        this.cmNew = new Action();
        this.cmEdit = new Action();
        this.cmDelete = new Action();
        this.cmExport = new Action();
        this.cmImport = new Action();
        this.buttonNew = new JButton();
        this.buttonEdit = new JButton();
        this.buttonDelete = new JButton();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tableSnippets = new ViewTable();
        this.buttonExport = new JButton();
        this.buttonImport = new JButton();
        this.checkSnippetsEnabled = new JCheckBox();
        this.cmNew.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/new16.gif"));
        this.cmNew.setText(this.stringManager.getString("cmNew-text"));
        this.cmNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SnippetsSettingsPanel.this.cmNewActionPerformed(evt);
            }
        });
        this.cmEdit.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/edit16.gif"));
        this.cmEdit.setText(this.stringManager.getString("cmEdit-text"));
        this.cmEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SnippetsSettingsPanel.this.cmEditActionPerformed(evt);
            }
        });
        this.cmDelete.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDelete.setText(this.stringManager.getString("cmDelete-text"));
        this.cmDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SnippetsSettingsPanel.this.cmDeleteActionPerformed(evt);
            }
        });
        this.cmExport.setActionCommandKey("cmExport");
        this.cmExport.setText(this.stringManager.getString("cmExport-text"));
        this.cmExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SnippetsSettingsPanel.this.cmExportActionPerformed(evt);
            }
        });
        this.cmImport.setActionCommandKey("cmImport");
        this.cmImport.setText(this.stringManager.getString("cmImport-text"));
        this.cmImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SnippetsSettingsPanel.this.cmImportActionPerformed(evt);
            }
        });
        this.buttonNew.setAction((javax.swing.Action)this.cmNew);
        this.buttonNew.setMargin(new Insets(2, 2, 2, 2));
        this.buttonNew.setPreferredSize(new Dimension(85, 25));
        this.buttonEdit.setAction((javax.swing.Action)this.cmEdit);
        this.buttonEdit.setMargin(new Insets(2, 2, 2, 2));
        this.buttonEdit.setPreferredSize(new Dimension(85, 25));
        this.buttonDelete.setAction((javax.swing.Action)this.cmDelete);
        this.buttonDelete.setMargin(new Insets(2, 2, 2, 2));
        this.buttonDelete.setPreferredSize(new Dimension(85, 25));
        this.jLabel1.setText(this.stringManager.getString("SnippetsSettingsPanel-defined-macro-info"));
        this.jScrollPane1.setViewportView((Component)this.tableSnippets);
        this.buttonExport.setAction((javax.swing.Action)this.cmExport);
        this.buttonExport.setMargin(new Insets(2, 2, 2, 2));
        this.buttonExport.setPreferredSize(new Dimension(85, 25));
        this.buttonImport.setAction((javax.swing.Action)this.cmImport);
        this.buttonImport.setMargin(new Insets(2, 2, 2, 2));
        this.buttonImport.setPreferredSize(new Dimension(85, 25));
        this.checkSnippetsEnabled.setText(this.stringManager.getString("checkSnippetsEnabled-text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 502, Short.MAX_VALUE).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.buttonExport, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonImport, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 59, Short.MAX_VALUE).addComponent(this.buttonNew, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonEdit, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonDelete, -2, -1, -2).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.checkSnippetsEnabled).addContainerGap(449, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel1, -1, 502, Short.MAX_VALUE).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.checkSnippetsEnabled).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 290, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonNew, -2, -1, -2).addComponent(this.buttonEdit, -2, -1, -2).addComponent(this.buttonDelete, -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonExport, -2, -1, -2).addComponent(this.buttonImport, -2, -1, -2))).addContainerGap()));
    }

    private void cmNewActionPerformed(ActionEvent evt) {
        try {
            String snp_id;
            if (this.tableSnippets.getQuery().isActive() && (snp_id = SnippetEditDialog.show(this.application, null)) != null) {
                this.changed = true;
                this.refresh(snp_id);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmEditActionPerformed(ActionEvent evt) {
        try {
            if (this.tableSnippets.getQuery().isActive() && this.tableSnippets.getSelectedRow() >= 0) {
                this.tableSnippets.getQuery().getRecord(this.tableSnippets.getSelectedRow());
                String snp_id = SnippetEditDialog.show(this.application, this.tableSnippets.getQuery().fieldByName("snp_id").getString());
                if (snp_id != null) {
                    this.changed = true;
                    this.refresh(snp_id);
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmDeleteActionPerformed(ActionEvent evt) {
        try {
            if (this.tableSnippets.getQuery().isActive() && this.tableSnippets.getSelectedRow() >= 0) {
                this.tableSnippets.getQuery().getRecord(this.tableSnippets.getSelectedRow());
                if (MessageBox.show((Component)this, (String)this.stringManager.getString("deleting"), (String)String.format(this.stringManager.getString("SnippetsSettingsPanel-del-snippet-q"), this.tableSnippets.getQuery().fieldByName("snp_name").getString()), (int[])ModalResult.YESNO, (int)3) == 5) {
                    SnippetRecord macro = new SnippetRecord(this.application.getOrbadaDatabase());
                    macro.setPrimaryKeyValue(new Variant(this.tableSnippets.getQuery().fieldByName("snp_id").getString()));
                    macro.applyDelete();
                    this.changed = true;
                    this.refresh(null);
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmExportActionPerformed(ActionEvent evt) {
        try {
            if (this.tableSnippets.getQuery().isActive() && this.tableSnippets.getSelectedRow() >= 0) {
                this.tableSnippets.getQuery().getRecord(this.tableSnippets.getSelectedRow());
                File file = FileUtil.selectFileToSave((Component)this, (String)this.stringManager.getString("save-snippet"), (FileExtensionFilter[])new FileExtensionFilter[]{new FileExtensionFilter(this.stringManager.getString("snippet-files"), new String[]{".xml.snippet"})});
                if (file != null) {
                    SnippetRecord macro = new SnippetRecord(this.application.getOrbadaDatabase(), this.tableSnippets.getQuery().fieldByName("snp_id").getString());
                    macro.storeToXML(new FileOutputStream(file), null, "utf-8");
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmImportActionPerformed(ActionEvent evt) {
        try {
            if (this.tableSnippets.getQuery().isActive() && this.tableSnippets.getSelectedRow() >= 0) {
                this.tableSnippets.getQuery().getRecord(this.tableSnippets.getSelectedRow());
                File file = FileUtil.selectFileToOpen((Component)this, (String)this.stringManager.getString("open-snippet"), (File)null, (FileExtensionFilter[])new FileExtensionFilter[]{new FileExtensionFilter(this.stringManager.getString("snippet-files"), new String[]{".xml.snippet"})});
                if (file != null) {
                    String snp_id;
                    SnippetRecord macro = new SnippetRecord(this.application.getOrbadaDatabase());
                    macro.loadFromXML(new FileInputStream(file));
                    macro.setId(new UniqueID().toString());
                    if (!this.application.isUserAdmin() || macro.getUsrId() != null) {
                        macro.setUsrId(this.application.getUserId());
                    }
                    if ((snp_id = SnippetEditDialog.show(this.application, null, macro)) != null) {
                        this.changed = true;
                        this.refresh(snp_id);
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }
}

