/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.laf.jtatoo.gui;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.laf.jtatoo.OrbadaLafJTatooPlugin;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.ISettingsComponent;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.ComboBox;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class GlobalOptionsSettingsPanel
extends JPanel
implements ISettingsComponent {
    private StringManager i18n = StringManagerFactory.getStringManager(OrbadaLafJTatooPlugin.class);
    private IApplication application;
    private File propFile;
    private Properties props;
    private int selectedTheme = -1;
    private String lafId;
    private static final HashMap<String, String[]> themes = new HashMap();
    private ComboBox comboThemes;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel labelThemes;
    private TextField textCompanyName;
    private TextField textLicenseKey;

    public GlobalOptionsSettingsPanel(IApplication application) {
        this.application = application;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.propFile = new File(this.application.getConfigPath() + "/" + "laf-jtatoo.properties");
        this.props = new Properties();
        if (this.propFile.exists()) {
            try {
                this.props.load(new FileInputStream(this.propFile));
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.i18n.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
                ExceptionUtil.processException((Throwable)ex);
            }
        }
        this.lafId = this.application.getSettings("orbada-settings").getValue("look-and-feel", "");
        this.restoreSettings();
    }

    public void restoreSettings() {
        this.textLicenseKey.setText(this.props.getProperty("license-key"));
        this.textCompanyName.setText(this.props.getProperty("company-name"));
        String[] themeList = themes.get(this.lafId);
        if (themeList != null) {
            this.comboThemes.setModel(new DefaultComboBoxModel<String>(themeList));
            String currentTheme = this.props.getProperty(this.lafId + "-current-theme", themeList[0]);
            for (int i = 0; i < themeList.length; ++i) {
                if (!themeList[i].equals(currentTheme)) continue;
                this.comboThemes.setSelectedIndex(i);
                this.selectedTheme = i;
                break;
            }
            if (this.comboThemes.getSelectedIndex() == -1) {
                this.comboThemes.setSelectedIndex(0);
                this.selectedTheme = 0;
            }
            this.labelThemes.setEnabled(true);
            this.comboThemes.setEnabled(true);
        } else {
            this.comboThemes.setModel(new DefaultComboBoxModel());
            this.labelThemes.setEnabled(false);
            this.comboThemes.setEnabled(false);
        }
    }

    public void applySettings() {
        this.props.setProperty("license-key", this.textLicenseKey.getText());
        this.props.setProperty("company-name", this.textCompanyName.getText());
        if (this.comboThemes.isEnabled()) {
            this.props.setProperty(this.lafId + "-current-theme", this.comboThemes.getText());
        }
        try {
            this.props.store(new FileOutputStream(this.propFile), "");
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        if (this.selectedTheme != this.comboThemes.getSelectedIndex()) {
            this.application.updateLAF();
        }
    }

    public void cancelSettings() {
        this.restoreSettings();
    }

    private void initComponents() {
        this.labelThemes = new JLabel();
        this.comboThemes = new ComboBox();
        this.jLabel2 = new JLabel();
        this.textLicenseKey = new TextField();
        this.jLabel3 = new JLabel();
        this.textCompanyName = new TextField();
        this.labelThemes.setHorizontalAlignment(11);
        this.labelThemes.setText(this.i18n.getString("jtatoo-current-theme-dd"));
        this.jLabel2.setHorizontalAlignment(11);
        this.jLabel2.setText(this.i18n.getString("jtatoo-license-key-dd"));
        this.jLabel3.setHorizontalAlignment(11);
        this.jLabel3.setText(this.i18n.getString("jtatoo-company-name-dd"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.labelThemes, GroupLayout.Alignment.LEADING, -1, 141, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent((Component)this.textCompanyName, -1, -1, Short.MAX_VALUE).addComponent((Component)this.textLicenseKey, -1, -1, Short.MAX_VALUE).addComponent((Component)this.comboThemes, -1, 179, Short.MAX_VALUE)).addContainerGap(221, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelThemes).addComponent((Component)this.comboThemes, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent((Component)this.textLicenseKey, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this.textCompanyName, -2, -1, -2)).addContainerGap(256, Short.MAX_VALUE)));
    }

    static {
        themes.put("jtatoo-acryl-look-and-feel-service", new String[]{"Default", "Small-Font", "Large-Font", "Giant-Font", "Green", "Green-Small-Font", "Green-Large-Font", "Green-Giant-Font", "Lemmon", "Lemmon-Small-Font", "Lemmon-Large-Font", "Lemmon-Giant-Font", "Red", "Red-Small-Font", "Red-Large-Font", "Red-Giant-Font"});
        themes.put("jtatoo-aero-look-and-feel-service", new String[]{"Default", "Small-Font", "Large-Font", "Giant-Font", "Gold", "Gold-Small-Font", "Gold-Large-Font", "Gold-Giant-Font", "Green", "Green-Small-Font", "Green-Large-Font", "Green-Giant-Font"});
        themes.put("jtatoo-aluminium-look-and-feel-service", new String[]{"Default", "Small-Font", "Large-Font", "Giant-Font"});
        themes.put("jtatoo-bernstein-look-and-feel-service", new String[]{"Default", "Small-Font", "Large-Font", "Giant-Font"});
        themes.put("jtatoo-fast-look-and-feel-service", new String[]{"Default", "Small-Font", "Large-Font", "Giant-Font", "Blue", "Blue-Small-Font", "Blue-Large-Font", "Blue-Giant-Font", "Green", "Green-Small-Font", "Green-Large-Font", "Green-Giant-Font"});
        themes.put("jtatoo-graphite-look-and-feel-service", new String[]{"Default", "Small-Font", "Large-Font", "Giant-Font", "Green-Small-Font", "Green-Medium-Font", "Green-Large-Font", "Blue-Small-Font", "Blue-Medium-Font", "Blue-Large-Font"});
        themes.put("jtatoo-hifi-look-and-feel-service", new String[]{"Default", "Small-Font", "Large-Font", "Giant-Font"});
        themes.put("jtatoo-luna-look-and-feel-service", new String[]{"Default", "Small-Font", "Large-Font", "Giant-Font"});
        themes.put("jtatoo-mcwin-look-and-feel-service", new String[]{"Default", "Small-Font", "Large-Font", "Giant-Font"});
        themes.put("jtatoo-mint-look-and-feel-service", new String[]{"Default", "Small-Font", "Large-Font", "Giant-Font"});
        themes.put("jtatoo-noire-look-and-feel-service", new String[]{"Default", "Small-Font", "Large-Font", "Giant-Font"});
        themes.put("jtatoo-smart-look-and-feel-service", new String[]{"Default", "Small-Font", "Large-Font", "Giant-Font", "Gold", "Gold-Small-Font", "Gold-Large-Font", "Gold-Giant-Font", "Green", "Green-Small-Font", "Green-Large-Font", "Green-Giant-Font", "Brown", "Brown-Small-Font", "Brown-Large-Font", "Brown-Giant-Font", "Lemmon", "Lemmon-Small-Font", "Lemmon-Large-Font", "Lemmon-Giant-Font", "Gray", "Gray-Small-Font", "Gray-Large-Font", "Gray-Giant-Font"});
    }
}

