/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.laf.jtatoo.starters.abs;

import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.concurrent.Callable;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.providers.ILookAndFeelStarter;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.util.ClassUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringUtil;

public abstract class JTatooLookAndFeelStarter
implements ILookAndFeelStarter {
    protected IApplication application;
    protected Properties properties;
    public static final String configFileName = "laf-jtatoo.properties";
    public static final String set_CurrentTheme = "-current-theme";
    public static final String set_LicenseKey = "license-key";
    public static final String set_CompanyName = "company-name";
    protected String licenseKey;
    protected String companyName;
    protected String themeName;

    public void setApplication(IApplication application) {
        this.application = application;
        this.properties = new Properties();
        File file = new File(application.getConfigPath() + "/" + configFileName);
        if (file.exists()) {
            try {
                this.properties.load(new FileInputStream(file));
                this.licenseKey = this.properties.getProperty(set_LicenseKey);
                this.companyName = this.properties.getProperty(set_CompanyName);
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    protected void applySettings(String className, String lafId) {
        Class<?> clazz;
        Toolkit.getDefaultToolkit().setDynamicLayout(true);
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        this.themeName = this.properties.getProperty(lafId + set_CurrentTheme);
        try {
            clazz = this.getClass().getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            ExceptionUtil.processException((Throwable)ex);
            return;
        }
        final Method m = ClassUtil.getStaticMethod(clazz, (String)"setTheme", (Class[])new Class[]{String.class});
        final Method mex = ClassUtil.getStaticMethod(clazz, (String)"setTheme", (Class[])new Class[]{String.class, String.class, String.class});
        if (m != null && mex != null) {
            SwingUtil.invokeAndWait((Callable)new Callable(){

                public Object call() throws Exception {
                    if (!StringUtil.isEmpty((String)JTatooLookAndFeelStarter.this.themeName)) {
                        if (!StringUtil.isEmpty((String)JTatooLookAndFeelStarter.this.companyName)) {
                            mex.invoke(null, JTatooLookAndFeelStarter.this.themeName, JTatooLookAndFeelStarter.this.licenseKey, JTatooLookAndFeelStarter.this.companyName);
                        } else {
                            m.invoke(null, JTatooLookAndFeelStarter.this.themeName);
                        }
                    }
                    UIManager.setLookAndFeel((LookAndFeel)clazz.newInstance());
                    return null;
                }
            });
        }
    }
}

