/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.adder.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pl.mpak.orbada.adder.OrbadaAdderPlugin;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ActionListCellRenderer;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.core.QueryField;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.variant.Variant;

public class AdderSelectorDialog
extends JDialog {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaAdderPlugin.class);
    private QueryTable table;
    private Query query;
    private QueryField field;
    private Action cmAvg;
    private Action cmConcat;
    private Action cmMax;
    private Action cmMin;
    private Action cmSum;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JList listSelect;

    public static void showDialog(QueryTable table) {
        AdderSelectorDialog dialog = new AdderSelectorDialog(table);
        dialog.setVisible(true);
    }

    public AdderSelectorDialog(QueryTable table) {
        super(SwingUtil.getWindowComponent((Component)table));
        this.table = table;
        this.query = table.getQuery();
        this.field = ((QueryTableColumn)table.getColumnModel().getColumn(table.getSelectedColumn())).getField();
        this.initComponents();
        this.init();
    }

    private void init() {
        int left;
        this.listSelect.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    ((Action)AdderSelectorDialog.this.listSelect.getSelectedValue()).performe();
                    AdderSelectorDialog.this.dispose();
                    evt.consume();
                } else if (evt.getKeyCode() == 27) {
                    AdderSelectorDialog.this.dispose();
                    evt.consume();
                }
            }
        });
        this.listSelect.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    ((Action)AdderSelectorDialog.this.listSelect.getSelectedValue()).performe();
                    AdderSelectorDialog.this.dispose();
                    e.consume();
                }
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
        this.listSelect.setCellRenderer(new ActionListCellRenderer());
        DefaultListModel<Action> model = new DefaultListModel<Action>();
        this.listSelect.setModel(model);
        model.addElement(this.cmSum);
        model.addElement(this.cmAvg);
        model.addElement(this.cmMin);
        model.addElement(this.cmMax);
        model.addElement(this.cmConcat);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                AdderSelectorDialog.this.listSelect.setSelectedIndex(0);
            }
        });
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle rect = this.table.getCellRect(0, this.table.getSelectedColumn(), true);
        Point point = this.table.getLocationOnScreen();
        int top = point.y - this.getHeight();
        if (top < 10) {
            top = 10;
        }
        if ((left = point.x + rect.x + (rect.width - (this.getWidth() + 10)) / 2) < 10) {
            left = 10;
        } else if ((double)(left + this.getWidth()) > screenSize.getWidth()) {
            left = (int)screenSize.getWidth() - 10 - this.getWidth();
        }
        this.setBounds(left, top, this.getWidth() + 10, this.getHeight());
    }

    private void copyToClipboard(String value) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection data = new StringSelection(value);
        clipboard.setContents(data, data);
    }

    private void initComponents() {
        this.cmSum = new Action();
        this.cmAvg = new Action();
        this.cmMin = new Action();
        this.cmMax = new Action();
        this.cmConcat = new Action();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.listSelect = new JList();
        this.cmSum.setSmallIcon((Icon)new ImageIcon(this.getClass().getResource("/pl/mpak/res/icons/sum.gif")));
        this.cmSum.setText(this.stringManager.getString("cmSum-text"));
        this.cmSum.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AdderSelectorDialog.this.cmSumActionPerformed(evt);
            }
        });
        this.cmAvg.setText(this.stringManager.getString("cmAvg-text"));
        this.cmAvg.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AdderSelectorDialog.this.cmAvgActionPerformed(evt);
            }
        });
        this.cmMin.setText(this.stringManager.getString("cmMin-text"));
        this.cmMin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AdderSelectorDialog.this.cmMinActionPerformed(evt);
            }
        });
        this.cmMax.setText(this.stringManager.getString("cmMax-text"));
        this.cmMax.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AdderSelectorDialog.this.cmMaxActionPerformed(evt);
            }
        });
        this.cmConcat.setText(this.stringManager.getString("cmConcat-text"));
        this.cmConcat.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AdderSelectorDialog.this.cmConcatActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(this.stringManager.getString("AdderSelectorDialog-title"));
        this.setUndecorated(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowDeactivated(WindowEvent evt) {
                AdderSelectorDialog.this.formWindowDeactivated(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createBevelBorder(0));
        this.jPanel1.setLayout(new BorderLayout());
        this.listSelect.setFixedCellHeight(18);
        this.jScrollPane1.setViewportView(this.listSelect);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
    }

    private void formWindowDeactivated(WindowEvent evt) {
        if (this.isVisible()) {
            this.dispose();
        }
    }

    private void cmSumActionPerformed(ActionEvent evt) {
        try {
            final Variant v = new Variant(new BigDecimal(0));
            this.query.first();
            while (!this.query.eof()) {
                if (!this.field.getValue().isNull()) {
                    v.add(this.field.getValue());
                }
                this.query.next();
            }
            this.copyToClipboard(v.toString());
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    MessageBox.show((String)AdderSelectorDialog.this.stringManager.getString("result"), (String)String.format(AdderSelectorDialog.this.stringManager.getString("sum-result"), v.toString()));
                }
            });
        }
        catch (NumberFormatException ex) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    MessageBox.show(null, (String)AdderSelectorDialog.this.stringManager.getString("error"), (String)AdderSelectorDialog.this.stringManager.getString("non-numeric-value"), (int)1, (int)0);
                }
            });
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmAvgActionPerformed(ActionEvent evt) {
        try {
            final Variant v = new Variant(new BigDecimal(0));
            int count = 0;
            this.query.first();
            while (!this.query.eof()) {
                if (!this.field.getValue().isNull()) {
                    v.add(this.field.getValue());
                    ++count;
                }
                this.query.next();
            }
            v.divide(new Variant(count));
            this.copyToClipboard(v.toString());
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    MessageBox.show((String)AdderSelectorDialog.this.stringManager.getString("result"), (String)String.format(AdderSelectorDialog.this.stringManager.getString("avg-result"), v.toString()));
                }
            });
        }
        catch (NumberFormatException ex) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    MessageBox.show(null, (String)AdderSelectorDialog.this.stringManager.getString("error"), (String)AdderSelectorDialog.this.stringManager.getString("non-numeric-value"), (int)1, (int)0);
                }
            });
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmMinActionPerformed(ActionEvent evt) {
        try {
            final Variant v = new Variant();
            this.query.first();
            while (!this.query.eof()) {
                if (!this.field.getValue().isNull() && (this.field.getValue().compareTo(v) < 0 || v.isNullValue())) {
                    v.setVariant(this.field.getValue());
                }
                this.query.next();
            }
            this.copyToClipboard(v.toString());
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    MessageBox.show((String)AdderSelectorDialog.this.stringManager.getString("result"), (String)String.format(AdderSelectorDialog.this.stringManager.getString("min-result"), v.toString()));
                }
            });
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmMaxActionPerformed(ActionEvent evt) {
        try {
            final Variant v = new Variant();
            this.query.first();
            while (!this.query.eof()) {
                if (!this.field.getValue().isNull() && (this.field.getValue().compareTo(v) > 0 || v.isNullValue())) {
                    v.setVariant(this.field.getValue());
                }
                this.query.next();
            }
            this.copyToClipboard(v.toString());
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    MessageBox.show((String)AdderSelectorDialog.this.stringManager.getString("result"), (String)String.format(AdderSelectorDialog.this.stringManager.getString("max-result"), v.toString()));
                }
            });
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void cmConcatActionPerformed(ActionEvent evt) {
        try {
            StringBuffer sb = new StringBuffer();
            this.query.first();
            while (!this.query.eof()) {
                if (!this.field.getValue().isNull()) {
                    sb.append(this.field.getString());
                }
                this.query.next();
            }
            this.copyToClipboard(sb.toString());
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    MessageBox.show((String)AdderSelectorDialog.this.stringManager.getString("result"), (String)AdderSelectorDialog.this.stringManager.getString("concat-result"));
                }
            });
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }
}

