/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.reports.db;

import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.br.DefaultBufferedRecord;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.id.UniqueID;
import pl.mpak.util.variant.Variant;
import pl.mpak.util.variant.VariantException;

public class ReportRecord
extends DefaultBufferedRecord {
    public ReportRecord(Database database) {
        super(database, "OREP_REPORTS", "OREP_ID");
        this.add("OREP_ID", new Variant(new UniqueID().toString()), 11, false);
        this.add("OREP_CREATED", 20, true);
        this.add("OREP_UPDATED", 20, true);
        this.add("OREP_OREPG_ID", 11, true);
        this.add("OREP_OREP_ID", 11, true);
        this.add("OREP_NAME", 11, true);
        this.add("OREP_DESCRIPTION", 11, true);
        this.add("OREP_TOOLTIP", 11, true);
        this.add("OREP_TYPE", new Variant("T"), 11, true);
        this.add("OREP_ARRANGE", new Variant("H"), 11, true);
        this.add("OREP_SQL", 11, true);
    }

    public ReportRecord(Database database, String orep_id) throws UseDBException {
        this(database);
        this.loadRecord(new Variant(orep_id));
    }

    public String getId() {
        return this.fieldByName("OREP_ID").getValue().toString();
    }

    public void setId(String id) {
        this.fieldByName("OREP_ID").setString(id);
    }

    public Long getCreated() {
        try {
            return this.fieldByName("OREP_CREATED").getLong();
        }
        catch (VariantException ex) {
            ExceptionUtil.processException((Throwable)ex);
            return null;
        }
    }

    public void setCreated(Long created) {
        this.fieldByName("OREP_CREATED").setLong(created.longValue());
    }

    public void setCreated(String created) {
        this.fieldByName("OREP_CREATED").setString(created);
    }

    public Long getUpdated() {
        try {
            return this.fieldByName("OREP_UPDATED").getLong();
        }
        catch (VariantException ex) {
            ExceptionUtil.processException((Throwable)ex);
            return null;
        }
    }

    public void setUpdated(Long created) {
        this.fieldByName("OREP_UPDATED").setLong(created.longValue());
    }

    public void setUpdated(String created) {
        this.fieldByName("OREP_UPDATED").setString(created);
    }

    public String getOrepgId() {
        if (this.fieldByName("OREP_OREPG_ID").isNull()) {
            return null;
        }
        return this.fieldByName("OREP_OREPG_ID").getValue().toString();
    }

    public void setOrepgId(String id) {
        this.fieldByName("OREP_OREPG_ID").setString(id);
    }

    public String getOrepId() {
        if (this.fieldByName("OREP_OREP_ID").isNull()) {
            return null;
        }
        return this.fieldByName("OREP_OREP_ID").getValue().toString();
    }

    public void setOrepId(String id) {
        this.fieldByName("OREP_OREP_ID").setString(id);
    }

    public String getName() {
        return this.fieldByName("OREP_NAME").getValue().toString();
    }

    public void setName(String name) {
        this.fieldByName("OREP_NAME").setString(name);
    }

    public String getDescription() {
        return this.fieldByName("OREP_DESCRIPTION").getValue().toString();
    }

    public void setDescription(String description) {
        this.fieldByName("OREP_DESCRIPTION").setString(description);
    }

    public String getTooltip() {
        return this.fieldByName("OREP_TOOLTIP").getValue().toString();
    }

    public void setTooltip(String tooltip) {
        this.fieldByName("OREP_TOOLTIP").setString(tooltip);
    }

    public String getType() {
        return this.fieldByName("OREP_TYPE").getValue().toString();
    }

    public void setType(String type) {
        this.fieldByName("OREP_TYPE").setString(type);
    }

    public String getArrange() {
        return this.fieldByName("OREP_ARRANGE").getValue().toString();
    }

    public void setArrange(String arrange) {
        this.fieldByName("OREP_ARRANGE").setString(arrange);
    }

    public String getSql() {
        return this.fieldByName("OREP_SQL").getValue().toString();
    }

    public void setSql(String sql) {
        this.fieldByName("OREP_SQL").setString(sql);
    }

    public void applyInsert() throws Exception {
        if (!this.fieldByName("OREP_CREATED").isChanged()) {
            this.fieldByName("OREP_CREATED").setValue(new Variant(System.currentTimeMillis()));
        }
        if (!this.fieldByName("OREP_UPDATED").isChanged()) {
            this.fieldByName("OREP_UPDATED").setLong(System.currentTimeMillis());
        }
        super.applyInsert();
    }

    public void applyUpdate() throws Exception {
        if (!this.fieldByName("OREP_UPDATED").isChanged()) {
            this.fieldByName("OREP_UPDATED").setLong(System.currentTimeMillis());
        }
        super.applyUpdate();
    }
}

