/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.reports.db;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.br.DefaultBufferedRecord;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringUtil;
import pl.mpak.util.id.UniqueID;
import pl.mpak.util.variant.Variant;
import pl.mpak.util.variant.VariantException;

public class ReportsGroupRecord
extends DefaultBufferedRecord {
    public ReportsGroupRecord(Database database, Object beanObject) throws IllegalArgumentException, VariantException, IllegalAccessException, InvocationTargetException, ParseException, IOException {
        super(database, beanObject);
    }

    public ReportsGroupRecord(Database database) {
        super(database, "OREP_GROUPS", "OREPG_ID");
        this.add("OREPG_ID", new Variant(new UniqueID().toString()), 11, false);
        this.add("OREPG_CREATED", 20, true);
        this.add("OREPG_UPDATED", 20, true);
        this.add("OREPG_OREPG_ID", 11, true);
        this.add("OREPG_DTP_ID", 11, true);
        this.add("OREPG_USR_ID", 11, true);
        this.add("OREPG_SCH_ID", 11, true);
        this.add("OREPG_SHARED", 11, true);
        this.add("OREPG_NAME", 11, true);
        this.add("OREPG_DESCRIPTION", 11, true);
        this.add("OREPG_TOOLTIP", 11, true);
    }

    public ReportsGroupRecord(Database database, String orepg_id) throws UseDBException {
        this(database);
        this.loadRecord(new Variant(orepg_id));
    }

    public String getId() {
        return this.fieldByName("OREPG_ID").getValue().toString();
    }

    public void setId(String id) {
        this.fieldByName("OREPG_ID").setString(id);
    }

    public Long getCreated() {
        try {
            return this.fieldByName("OREPG_CREATED").getLong();
        }
        catch (VariantException ex) {
            ExceptionUtil.processException((Throwable)ex);
            return null;
        }
    }

    public void setCreated(Long created) {
        this.fieldByName("OREPG_CREATED").setLong(created.longValue());
    }

    public void setCreated(String created) {
        this.fieldByName("OREPG_CREATED").setString(created);
    }

    public Long getUpdated() {
        try {
            return this.fieldByName("OREPG_UPDATED").getLong();
        }
        catch (VariantException ex) {
            ExceptionUtil.processException((Throwable)ex);
            return null;
        }
    }

    public void setUpdated(Long created) {
        this.fieldByName("OREPG_UPDATED").setLong(created.longValue());
    }

    public void setUpdated(String created) {
        this.fieldByName("OREPG_UPDATED").setString(created);
    }

    public String getUsrId() {
        if (this.fieldByName("OREPG_USR_ID").isNull()) {
            return null;
        }
        return this.fieldByName("OREPG_USR_ID").getValue().toString();
    }

    public void setUsrId(String id) {
        this.fieldByName("OREPG_USR_ID").setString(id);
    }

    public String getDtpId() {
        return this.fieldByName("OREPG_DTP_ID").getValue().toString();
    }

    public void setDtpId(String id) {
        this.fieldByName("OREPG_DTP_ID").setString(id);
    }

    public String getSchId() {
        if (this.fieldByName("OREPG_SCH_ID").isNull()) {
            return null;
        }
        return this.fieldByName("OREPG_SCH_ID").getValue().toString();
    }

    public void setSchId(String id) {
        this.fieldByName("OREPG_SCH_ID").setString(id);
    }

    public String getOrepgId() {
        if (this.fieldByName("OREPG_OREPG_ID").isNull()) {
            return null;
        }
        return this.fieldByName("OREPG_OREPG_ID").getValue().toString();
    }

    public void setOrepgId(String id) {
        this.fieldByName("OREPG_OREPG_ID").setString(id);
    }

    public boolean isShared() {
        return StringUtil.toBoolean((String)this.getShared());
    }

    public String getShared() {
        return this.fieldByName("OREPG_SHARED").getValue().toString();
    }

    public void setShared(String shared) {
        this.fieldByName("OREPG_SHARED").setString(shared);
    }

    public void setShared(boolean shared) {
        this.setShared(shared ? "T" : "F");
    }

    public String getName() {
        return this.fieldByName("OREPG_NAME").getValue().toString();
    }

    public void setName(String name) {
        this.fieldByName("OREPG_NAME").setString(name);
    }

    public String getDescription() {
        return this.fieldByName("OREPG_DESCRIPTION").getValue().toString();
    }

    public void setDescription(String description) {
        this.fieldByName("OREPG_DESCRIPTION").setString(description);
    }

    public String getTooltip() {
        return this.fieldByName("OREPG_TOOLTIP").getValue().toString();
    }

    public void setTooltip(String tooltip) {
        this.fieldByName("OREPG_TOOLTIP").setString(tooltip);
    }

    public void applyInsert() throws Exception {
        if (!this.fieldByName("OREPG_CREATED").isChanged()) {
            this.fieldByName("OREPG_CREATED").setValue(new Variant(System.currentTimeMillis()));
        }
        if (!this.fieldByName("OREPG_UPDATED").isChanged()) {
            this.fieldByName("OREPG_UPDATED").setLong(System.currentTimeMillis());
        }
        super.applyInsert();
    }

    public void applyUpdate() throws Exception {
        if (!this.fieldByName("OREPG_UPDATED").isChanged()) {
            this.fieldByName("OREPG_UPDATED").setLong(System.currentTimeMillis());
        }
        super.applyUpdate();
    }
}

