/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.export.datatext;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JTable;
import pl.mpak.datatext.sax.DataTextColumn;
import pl.mpak.datatext.sax.DataTextWriter;
import pl.mpak.orbada.export.datatext.ExportToDataTextDialog;
import pl.mpak.orbada.export.datatext.OrbadaExportDataTextPlugin;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.providers.ExportTableActionProvider;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.variant.Variant;

public class ExportToDataText
extends ExportTableActionProvider {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaExportDataTextPlugin.class);
    private String fileName;
    private String charset;

    public ExportToDataText() {
        this.setText(this.stringManager.getString("ExportToDataText-text"));
        this.setActionCommandKey("ExportToDataText");
        this.addActionListener(this.createActionListener());
    }

    public String getDescription() {
        return this.stringManager.getString("ExportToDataText-description");
    }

    private ISettings getConfig() {
        return this.application.getSettings("export-to-data-text-file");
    }

    private void localConfig() {
        try {
            this.charset = this.getConfig().getValue("charset").getString();
            this.fileName = this.getConfig().getValue("file-name").getString();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportTable(JTable table) {
        File file = new File(this.fileName);
        if (file.exists()) {
            if (MessageBox.show((Component)SwingUtil.getRootFrame(), (String)this.stringManager.getString("export"), (String)this.stringManager.getString("ExportToDataText-rewrite-q"), (int[])ModalResult.YESNO, (int)3) == 6) {
                return;
            }
            file.delete();
        }
        DataTextWriter writer = null;
        try {
            writer = new DataTextWriter((OutputStream)new FileOutputStream(file), this.charset);
            writer.writeComment("Generated by Orbada");
            DataTextColumn[] columns = new DataTextColumn[table.getColumnCount()];
            for (int c = 0; c < table.getColumnCount(); ++c) {
                if (table.getColumnModel().getColumn(c) instanceof QueryTableColumn) {
                    QueryTableColumn column = (QueryTableColumn)table.getColumnModel().getColumn(c);
                    columns[c] = new DataTextColumn(column.getField().getOptimalSize(), column.getFieldName());
                    continue;
                }
                columns[c] = new DataTextColumn(table.getColumnModel().getColumn(c).getWidth() / 6, table.getColumnModel().getColumn(c).getHeaderValue().toString());
            }
            writer.writeHeader(null, columns);
            String[] values = new String[table.getColumnCount()];
            for (int r = 0; r < table.getRowCount(); ++r) {
                for (int c = 0; c < table.getColumnCount(); ++c) {
                    String s = "";
                    Object o = table.getValueAt(r, c);
                    if (o != null) {
                        s = o instanceof Variant ? ((Variant)o).getString() : o.toString();
                    }
                    values[c] = s;
                    if (values[c].length() <= columns[c].getLength()) continue;
                    values[c] = values[c].substring(0, columns[c].getLength() - 1);
                }
                writer.writeData(values);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            MessageBox.show((Component)null, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int[])new int[]{1});
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ex) {
                    ExceptionUtil.processException((Throwable)ex);
                }
            }
        }
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JTable table = ExportToDataText.this.getTable(event);
                if (table != null && ExportToDataTextDialog.showDialog(ExportToDataText.this.getConfig())) {
                    ExportToDataText.this.localConfig();
                    ExportToDataText.this.exportTable(table);
                }
            }
        };
    }

    public String getGroupName() {
        return "Export tools";
    }
}

